/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.netflix.infix.TimeUtil;
import com.netflix.infix.ValuePredicate;
import javax.annotation.Nullable;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormatter;

public class TimeRangeValuePredicate
implements ValuePredicate<Long> {
    private String timeFormat;
    private String start;
    private String end;
    private Interval interval;

    public TimeRangeValuePredicate(String timeFormat, String start, String end) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)timeFormat) ? 1 : 0) != 0, (Object)"Time format can't be null or empty. ");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)start) ? 1 : 0) != 0, (Object)"The lower bound of time range can't be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)end) ? 1 : 0) != 0, (Object)"The upper bound of time range  can't be null or empty. ");
        this.timeFormat = timeFormat;
        this.start = start;
        this.end = end;
        DateTimeFormatter format = TimeUtil.toDateTimeFormatter("time format", timeFormat);
        long startInstant = format.parseMillis(start);
        long endInstant = format.parseMillis(end);
        try {
            this.interval = new Interval(startInstant, endInstant);
        }
        catch (IllegalArgumentException e) {
            String msg = String.format("The lower bound should be smaller than or equal to upper bound for a time range. Given range: [%s, %s)", start, end);
            IllegalArgumentException iae = new IllegalArgumentException(msg, e.getCause());
            iae.setStackTrace(e.getStackTrace());
            throw iae;
        }
    }

    public boolean apply(@Nullable Long input) {
        return null != input && this.interval.contains(input.longValue());
    }

    public String getStart() {
        return this.start;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    String getEnd() {
        return this.end;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeRangeValuePredicate [timeFormat=");
        builder.append(this.timeFormat);
        builder.append(", start=");
        builder.append(this.start);
        builder.append(", end=");
        builder.append(this.end);
        builder.append(", interval=");
        builder.append(this.interval);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.timeFormat == null ? 0 : this.timeFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRangeValuePredicate other = (TimeRangeValuePredicate)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.timeFormat == null ? other.timeFormat != null : !this.timeFormat.equals(other.timeFormat));
    }
}

