/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.parser.DialectFeature;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class BigQueryLexer
extends Lexer {
    @Override
    protected Keywords loadKeywords() {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.put("ALL", Token.ALL);
        map.put("AND", Token.AND);
        map.put("ANY", Token.ANY);
        map.put("ALTER", Token.ALTER);
        map.put("AS", Token.AS);
        map.put("ASC", Token.ASC);
        map.put("BETWEEN", Token.BETWEEN);
        map.put("BY", Token.BY);
        map.put("CASE", Token.CASE);
        map.put("CAST", Token.CAST);
        map.put("COLUMN", Token.COLUMN);
        map.put("CONTAINS", Token.CONTAINS);
        map.put("CREATE", Token.CREATE);
        map.put("CROSS", Token.CROSS);
        map.put("CURRENT", Token.CURRENT);
        map.put("DECLARE", Token.DECLARE);
        map.put("DEFAULT", Token.DEFAULT);
        map.put("DESC", Token.DESC);
        map.put("DISTINCT", Token.DISTINCT);
        map.put("DELETE", Token.DELETE);
        map.put("DROP", Token.DROP);
        map.put("DO", Token.DO);
        map.put("ELSE", Token.ELSE);
        map.put("END", Token.END);
        map.put("ESCAPE", Token.ESCAPE);
        map.put("EXCEPT", Token.EXCEPT);
        map.put("EXISTS", Token.EXISTS);
        map.put("EXTRACT", Token.EXTRACT);
        map.put("FUNCTION", Token.FUNCTION);
        map.put("FALSE", Token.FALSE);
        map.put("FETCH", Token.FETCH);
        map.put("FOR", Token.FOR);
        map.put("FOREIGN", Token.FOREIGN);
        map.put("FROM", Token.FROM);
        map.put("FULL", Token.FULL);
        map.put("GROUP", Token.GROUP);
        map.put("HAVING", Token.HAVING);
        map.put("INSERT", Token.INSERT);
        map.put("IF", Token.IF);
        map.put("IN", Token.IN);
        map.put("INNER", Token.INNER);
        map.put("INTERSECT", Token.INTERSECT);
        map.put("INTERVAL", Token.INTERVAL);
        map.put("INTO", Token.INTO);
        map.put("IS", Token.IS);
        map.put("JOIN", Token.JOIN);
        map.put("KEY", Token.KEY);
        map.put("LATERAL", Token.LATERAL);
        map.put("LEFT", Token.LEFT);
        map.put("LIKE", Token.LIKE);
        map.put("LIMIT", Token.LIMIT);
        map.put("MERGE", Token.MERGE);
        map.put("MATCHED", Token.MATCHED);
        map.put("NEW", Token.NEW);
        map.put("NOT", Token.NOT);
        map.put("NULL", Token.NULL);
        map.put("OF", Token.OF);
        map.put("ON", Token.ON);
        map.put("OR", Token.OR);
        map.put("ORDER", Token.ORDER);
        map.put("OUTER", Token.OUTER);
        map.put("OVER", Token.OVER);
        map.put("PARTITION", Token.PARTITION);
        map.put("PRIMARY", Token.PRIMARY);
        map.put("QUALIFY", Token.QUALIFY);
        map.put("RECURSIVE", Token.RECURSIVE);
        map.put("REFERENCES", Token.REFERENCES);
        map.put("REPLACE", Token.REPLACE);
        map.put("RIGHT", Token.RIGHT);
        map.put("ROWS", Token.ROWS);
        map.put("SELECT", Token.SELECT);
        map.put("SET", Token.SET);
        map.put("SOME", Token.SOME);
        map.put("THEN", Token.THEN);
        map.put("TO", Token.TO);
        map.put("TRUE", Token.TRUE);
        map.put("UPDATE", Token.UPDATE);
        map.put("UNION", Token.UNION);
        map.put("USING", Token.USING);
        map.put("VALUES", Token.VALUES);
        map.put("WHEN", Token.WHEN);
        map.put("WHERE", Token.WHERE);
        map.put("WINDOW", Token.WINDOW);
        map.put("WITH", Token.WITH);
        map.put("WHILE", Token.WHILE);
        map.put("LOOP", Token.LOOP);
        map.put("LEAVE", Token.LEAVE);
        map.put("CONTINUE", Token.CONTINUE);
        map.put("VIEW", Token.VIEW);
        map.put("TRUNCATE", Token.TRUNCATE);
        map.put("BEGIN", Token.BEGIN);
        map.put("TABLE", Token.TABLE);
        map.put("EXCEPTION", Token.EXCEPTION);
        map.put("RAISE", Token.RAISE);
        map.put("ELSEIF", Token.ELSEIF);
        return new Keywords(map);
    }

    public BigQueryLexer(String input, SQLParserFeature ... features) {
        super(input);
        this.dbType = DbType.bigquery;
        this.skipComment = true;
        this.keepComments = true;
        this.features |= SQLParserFeature.SupportUnicodeCodePoint.mask;
        for (SQLParserFeature feature : features) {
            this.config(feature, true);
        }
    }

    public final void nextTokenFullName() {
        this.nextToken();
    }

    @Override
    public boolean nextIf(Token token) {
        if (this.token == token) {
            boolean setFeature;
            boolean bl = setFeature = token == Token.DELETE || token == Token.FROM || token == Token.INTO || token == Token.JOIN;
            if (setFeature) {
                this.dialectFeature.configFeature(DialectFeature.LexerFeature.ScanSubAsIdentifier);
            }
            this.nextToken();
            if (setFeature) {
                this.dialectFeature.configFeature((DialectFeature.Feature)DialectFeature.LexerFeature.ScanSubAsIdentifier, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void scanIdentifier() {
        this.scanIdentifier0();
    }

    @Override
    protected void scanAlias() {
        if (this.pos + 2 < this.text.length() && this.text.charAt(this.pos + 1) == '\"' && this.text.charAt(this.pos + 2) == '\"') {
            for (int i = this.pos + 3; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (c != '\"' || i + 2 >= this.text.length() || this.text.charAt(i + 1) != '\"' || this.text.charAt(i + 2) != '\"') continue;
                this.stringVal = this.text.substring(this.pos + 3, i);
                this.token = Token.LITERAL_TEXT_BLOCK;
                this.pos = i + 2;
                this.scanChar();
                return;
            }
        }
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\"') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.text.substring(this.pos, endIndex + 1) : (startIndex == endIndex ? "" : this.text.substring(startIndex, endIndex));
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\"') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        Token preToken = this.token;
        block7: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\'': {
                        this.putChar('\'');
                        continue block7;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block7;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block7;
                    }
                }
                this.putChar('\\');
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\"') {
                this.scanChar();
                if (this.ch != '\"') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\"');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? (preToken == Token.AS ? this.subString(this.mark, this.bufPos + 2) : this.subString(this.mark + 1, this.bufPos)) : new String(this.buf, 0, this.bufPos);
    }

    @Override
    protected void initDialectFeature() {
        super.initDialectFeature();
        this.dialectFeature.configFeature(DialectFeature.ParserFeature.SQLDateExpr, DialectFeature.ParserFeature.GroupByAll, DialectFeature.ParserFeature.InRestSpecificOperation);
    }

    @Override
    public void scanSharp() {
        this.scanComment();
    }

    @Override
    public void scanComment() {
        if (this.ch == '/' && this.charAt(this.pos + 1) == '/' || this.ch == '-' && this.charAt(this.pos + 1) == '-' || this.ch == '#') {
            this.scanSingleLineComment();
        } else if (this.ch == '/' && this.charAt(this.pos + 1) == '*') {
            this.scanMultiLineComment();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void scanString() {
        if (this.pos + 2 < this.text.length() && this.text.charAt(this.pos + 1) == '\'' && this.text.charAt(this.pos + 2) == '\'') {
            for (int i = this.pos + 3; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (c != '\'' || i + 2 >= this.text.length() || this.text.charAt(i + 1) != '\'' || this.text.charAt(i + 2) != '\'') continue;
                this.stringVal = this.text.substring(this.pos + 3, i);
                this.token = Token.LITERAL_TEXT_BLOCK;
                this.pos = i + 2;
                this.scanChar();
                return;
            }
        }
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\'') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.text.substring(this.pos, endIndex + 1) : (startIndex == endIndex ? "" : this.text.substring(startIndex, endIndex));
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block7: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\'': {
                        this.putChar('\'');
                        continue block7;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block7;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block7;
                    }
                }
                this.putChar('\\');
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }
}

