/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gaussdb.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionSingle;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.gaussdb.ast.GaussDbDistributeBy;
import com.alibaba.druid.sql.dialect.gaussdb.ast.GaussDbPartitionValue;
import com.alibaba.druid.sql.dialect.gaussdb.ast.stmt.GaussDbCreateTableStatement;
import com.alibaba.druid.sql.dialect.gaussdb.ast.stmt.GaussDbInsertStatement;
import com.alibaba.druid.sql.dialect.gaussdb.visitor.GaussDbASTVisitor;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGVacuumStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class GaussDbOutputVisitor
extends PGOutputVisitor
implements GaussDbASTVisitor {
    public GaussDbOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.gaussdb;
    }

    public GaussDbOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.gaussdb;
    }

    @Override
    public boolean visit(GaussDbCreateTableStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        this.printCreateTableFeatures(x);
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getTableSource().getExpr());
        this.printCreateTableAfterName(x);
        this.printTableElements(x);
        this.printCreateTableLike(x);
        this.printTableOptions(x);
        this.printOnCommit(x);
        this.printCompressType(x);
        this.printDistributeBy(x);
        this.printToGroup(x);
        this.printToNode(x);
        this.printPartitionBy(x);
        this.printRowMovement(x);
        this.printComment(x.getComment());
        return false;
    }

    public void printRowMovement(GaussDbCreateTableStatement x) {
        if (x.getRowMovementType() != null) {
            this.println();
            x.getRowMovementType().accept(this);
            this.print(this.ucase ? " ROW MOVEMENT" : " row movement");
        }
    }

    public void printCompressType(GaussDbCreateTableStatement x) {
        if (x.getCompressType() != null) {
            this.println();
            x.getCompressType().accept(this);
        }
    }

    public void printOnCommit(GaussDbCreateTableStatement x) {
        if (x.getOnCommitExpr() != null) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT " : "on commit ");
            x.getOnCommitExpr().accept(this);
            this.print0(this.ucase ? " ROWS" : " rows");
        }
    }

    public void printDistributeBy(GaussDbCreateTableStatement x) {
        if (x.getDistributeBy() != null) {
            x.getDistributeBy().accept(this);
        }
    }

    public void printToGroup(GaussDbCreateTableStatement x) {
        if (x.getToGroup() != null) {
            this.println();
            this.print0(this.ucase ? "TO GROUP " : "to group ");
            x.getToGroup().accept(this);
        }
    }

    public void printToNode(GaussDbCreateTableStatement x) {
        if (x.getToNode() != null) {
            this.println();
            this.print0(this.ucase ? "TO NODE " : "to node ");
            x.getToNode().accept(this);
        }
    }

    @Override
    public boolean visit(SQLPartitionByRange x) {
        this.print0(this.ucase ? "RANGE" : "range");
        this.printColumns(x.getColumns());
        if (!x.getPartitions().isEmpty()) {
            this.printPartitionsValue(x.getPartitions());
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        this.print0(this.ucase ? "LIST" : "list");
        this.printColumns(x.getColumns());
        if (!x.getPartitions().isEmpty()) {
            this.printPartitionsValue(x.getPartitions());
        }
        return false;
    }

    @Override
    protected void printTableOptionsPrefix(SQLCreateTableStatement x) {
        this.println();
        this.print0(this.ucase ? "WITH (" : "with (");
        this.incrementIndent();
        this.println();
    }

    protected void printTableElements(GaussDbCreateTableStatement x) {
        int size = x.getTableElementList().size();
        if (size == 0) {
            return;
        }
        this.print0(" (");
        ++this.indentCount;
        this.println();
        for (int i = 0; i < size; ++i) {
            this.printTableElement(x.getTableElementList(), i);
        }
        --this.indentCount;
        if (!x.getClusteredBy().isEmpty()) {
            this.print(',');
            this.println();
            this.print(" ");
            List<SQLExpr> clusterBy = x.getClusteredBy().stream().map(k -> k.getExpr()).collect(Collectors.toList());
            this.print0(this.ucase ? "  PARTIAL CLUSTER KEY " : "  partial cluster key");
            this.printColumns(clusterBy);
        }
        this.println();
        this.print(')');
    }

    @Override
    public boolean visit(SQLPartitionValue value) {
        if (value instanceof GaussDbPartitionValue) {
            GaussDbPartitionValue x = (GaussDbPartitionValue)value;
            if (x.getOperator() == SQLPartitionValue.Operator.LessThan) {
                this.print0(this.ucase ? "VALUES LESS THAN" : "values less than");
                this.print0(" (");
                if (x.getItems().size() == 1) {
                    this.printExpr(x.getItems().get(0), this.parameterized);
                } else {
                    this.print("(");
                    this.printAndAccept(x.getItems(), ", ", false);
                    this.print(')');
                }
                this.print(")");
            } else if (x.getOperator() == SQLPartitionValue.Operator.StartEndEvery) {
                if (x.getStart() != null) {
                    this.print0(this.ucase ? " START " : " start ");
                    x.getStart().accept(this);
                }
                if (x.getEnd() != null) {
                    this.print0(this.ucase ? " END " : " end ");
                    x.getEnd().accept(this);
                }
                if (x.getEvery() != null) {
                    this.print0(this.ucase ? " EVERY " : " every ");
                    x.getEvery().accept(this);
                }
            } else if (x.getOperator() == SQLPartitionValue.Operator.List) {
                this.print0(this.ucase ? "VALUES " : "valuse ");
                this.print0(" (");
                if (x.getItems().size() == 1) {
                    this.printExpr(x.getItems().get(0), this.parameterized);
                } else {
                    this.print("(");
                    this.printAndAccept(x.getItems(), ", ", false);
                    this.print(')');
                }
                this.print0(")");
            }
            if (x.getSpaceName() != null) {
                this.print0(this.ucase ? " TABLESPACE " : " tablespace ");
                x.getSpaceName().accept(this);
            } else if (x.getDataNode() != null) {
                this.print0(this.ucase ? " DATANODE " : " datanode ");
                x.getDataNode().accept(this);
            }
        } else {
            super.visit(value);
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionSingle x) {
        GaussDbPartitionValue values = (GaussDbPartitionValue)x.getValues();
        if (values.getDistribute()) {
            this.print0(this.ucase ? "SLICE " : "slice ");
        } else {
            this.print0(this.ucase ? "PARTITION " : "partition ");
        }
        x.getName().accept(this);
        this.print0(" ");
        values.accept(this);
        return false;
    }

    public void printColumns(List<SQLExpr> columns) {
        for (SQLExpr column : columns) {
            if (!(column instanceof SQLName)) break;
        }
        if (columns.size() == 1) {
            this.print0(" (");
            columns.get(0).accept(this);
            this.print(')');
        } else {
            this.print0(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        super.visit(x);
        if (x.getOnUpdate() != null) {
            this.print0(this.ucase ? " ON UPDATE " : " on update ");
            x.getOnUpdate().accept(this);
        }
        return false;
    }

    public void printPartitionsValue(List<SQLPartition> partitions) {
        this.print(" (");
        ++this.indentCount;
        int size = partitions.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(',');
            }
            this.println();
            SQLPartition sqlPartition = partitions.get(i);
            sqlPartition.accept(this);
        }
        --this.indentCount;
        this.println();
        this.print(')');
    }

    @Override
    public boolean visit(GaussDbDistributeBy x) {
        this.println();
        this.print0(this.ucase ? "DISTRIBUTE BY " : "distribute by ");
        x.getType().accept(this);
        if (!x.getColumns().isEmpty()) {
            this.printColumns(x.getColumns());
        }
        if (!x.getDistributions().isEmpty()) {
            this.printPartitionsValue(x.getDistributions());
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (x instanceof GaussDbInsertStatement) {
            return this.visit((GaussDbInsertStatement)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        if (x instanceof GaussDbInsertStatement) {
            return this.visit((GaussDbInsertStatement)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(GaussDbInsertStatement x) {
        SQLWithSubqueryClause with;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        if (x.getInsertBeforeCommentsDirect() != null) {
            this.printlnComments(x.getInsertBeforeCommentsDirect());
        }
        if ((with = x.getWith()) != null) {
            this.visit(with);
            this.println();
        }
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "OVERWRITE " : "overwrite ");
        } else if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept(this);
        String columnsString = x.getColumnsString();
        if (columnsString != null) {
            this.print0(columnsString);
        } else {
            this.printInsertColumns(x.getColumns());
        }
        if (x.isDefaultValues()) {
            this.println();
            this.print0(this.ucase ? "DEFAULT VALUES" : "default values");
        }
        this.printValuesOrQuery(x);
        List<SQLExpr> duplicateKeyUpdate = x.getDuplicateKeyUpdate();
        if (!duplicateKeyUpdate.isEmpty()) {
            this.println();
            this.print0(this.ucase ? "ON DUPLICATE KEY UPDATE " : "on duplicate key update ");
            int size = duplicateKeyUpdate.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                duplicateKeyUpdate.get(i).accept(this);
            }
        }
        this.printOnConflict(x);
        this.printReturning(x);
        return false;
    }

    @Override
    protected void visitAggregateRest(SQLAggregateExpr x) {
        super.visitAggregateRest(x);
        Object value = x.getAttribute("SEPARATOR");
        if (value != null) {
            this.print0(this.ucase ? " SEPARATOR " : " separator ");
            ((SQLObject)value).accept(this);
        }
    }

    @Override
    protected void printCompression(SQLColumnDefinition x) {
        if (x.getCompression() != null) {
            this.print0(this.ucase ? " COMPRESS_MODE " : " compress_mode ");
            x.getCompression().accept(this);
        }
    }

    @Override
    public boolean visit(SQLIntervalExpr x) {
        this.print0(this.ucase ? "INTERVAL " : "interval ");
        SQLExpr value = x.getValue();
        boolean str = value instanceof SQLCharExpr;
        if (!str) {
            this.print('\'');
        }
        value.accept(this);
        SQLIntervalUnit unit = x.getUnit();
        if (unit != null) {
            SQLIntegerExpr integerExpr;
            this.print(' ');
            this.print0(this.ucase ? unit.name : unit.nameLCase);
            if (value instanceof SQLIntegerExpr && (integerExpr = (SQLIntegerExpr)value).getNumber().intValue() > 1) {
                this.print(this.ucase ? (char)'S' : 's');
            }
        }
        if (!str) {
            this.print('\'');
        }
        return false;
    }

    @Override
    protected void printVacuumRest(PGVacuumStatement x) {
        if (x.isDeltaMerge()) {
            this.print0(this.ucase ? "DELTAMERGE " : "deltamerge ");
        }
        if (x.isHdfsDirectory()) {
            this.print0(this.ucase ? "HDFSDIRECTORY " : "hdfsdirectory ");
        }
    }
}

