/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import com.networknt.schema.output.OutputUnitKey;
import com.networknt.schema.path.NodePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class HierarchicalOutputUnitFormatter {
    public static OutputUnit format(OutputUnit root, OutputUnitData data, NodePath rootPath) {
        String schemaLocation;
        String instanceLocation;
        OutputUnit unit;
        OutputUnitKey key;
        Map<OutputUnitKey, Boolean> valid = data.getValid();
        Map<OutputUnitKey, Map<String, Object>> errors = data.getErrors();
        Map<OutputUnitKey, Map<String, Object>> annotations = data.getAnnotations();
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.getDroppedAnnotations();
        LinkedHashMap index = new LinkedHashMap();
        LinkedHashMap<NodePath, OutputUnit> r = new LinkedHashMap<NodePath, OutputUnit>();
        r.put(rootPath, root);
        index.put(rootPath, r);
        LinkedHashMap keys = new LinkedHashMap();
        errors.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        annotations.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        droppedAnnotations.keySet().stream().forEach(k -> keys.computeIfAbsent(k.getEvaluationPath(), a -> new LinkedHashSet()).add(k.getInstanceLocation()));
        errors.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        annotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        droppedAnnotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        for (Map.Entry<OutputUnitKey, Map<String, Object>> error : errors.entrySet()) {
            key = error.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            unit.setInstanceLocation(key.getInstanceLocation().toString());
            unit.setSchemaLocation(key.getSchemaLocation().toString());
            unit.setValid(false);
            unit.setErrors(error.getValue());
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> annotation : annotations.entrySet()) {
            key = annotation.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setAnnotations(annotation.getValue());
            unit.setValid(valid.get(key));
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> droppedAnnotation : droppedAnnotations.entrySet()) {
            key = droppedAnnotation.getKey();
            unit = (OutputUnit)((Map)index.get(key.getEvaluationPath())).get(key.getInstanceLocation());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setDroppedAnnotations(droppedAnnotation.getValue());
            unit.setValid(valid.get(key));
        }
        return root;
    }

    public static OutputUnit format(Schema jsonSchema, List<Error> errors, ExecutionContext executionContext, SchemaContext schemaContext, Function<Error, Object> errorMapper) {
        OutputUnit root = new OutputUnit();
        root.setValid(errors.isEmpty());
        root.setInstanceLocation(schemaContext.getSchemaRegistryConfig().getPathType().getRoot());
        root.setEvaluationPath(schemaContext.getSchemaRegistryConfig().getPathType().getRoot());
        root.setSchemaLocation(jsonSchema.getSchemaLocation().toString());
        OutputUnitData data = OutputUnitData.from(errors, executionContext, errorMapper);
        return HierarchicalOutputUnitFormatter.format(root, data, new NodePath(schemaContext.getSchemaRegistryConfig().getPathType()));
    }

    protected static void buildIndex(OutputUnitKey key, Map<NodePath, Map<NodePath, OutputUnit>> index, Map<NodePath, Set<NodePath>> keys, OutputUnit root) {
        if (index.containsKey(key.getEvaluationPath())) {
            return;
        }
        ArrayDeque<NodePath> stack = new ArrayDeque<NodePath>();
        for (NodePath path = key.getEvaluationPath(); path != null && path.getElement(-1) != null; path = path.getParent()) {
            stack.push(path);
        }
        OutputUnit parent = root;
        block1: while (!stack.isEmpty()) {
            Map<NodePath, OutputUnit> result;
            NodePath current = (NodePath)stack.pop();
            if (!index.containsKey(current) && keys.containsKey(current)) {
                for (NodePath instanceLocation : keys.get(current)) {
                    OutputUnit child = new OutputUnit();
                    child.setValid(true);
                    child.setEvaluationPath(current.toString());
                    child.setInstanceLocation(instanceLocation.toString());
                    index.computeIfAbsent(current, n -> new LinkedHashMap()).put(instanceLocation, child);
                    if (parent.getDetails() == null) {
                        parent.setDetails(new ArrayList<OutputUnit>());
                    }
                    parent.getDetails().add(child);
                }
            }
            if ((result = index.get(current)) == null) continue;
            for (Map.Entry<NodePath, OutputUnit> entry : result.entrySet()) {
                if (!key.getInstanceLocation().startsWith(entry.getKey())) continue;
                parent = entry.getValue();
                continue block1;
            }
        }
    }
}

