/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.ctrip.framework.apollo.internals.DefaultConfigManager;
import com.ctrip.framework.apollo.internals.Injector;
import com.ctrip.framework.apollo.internals.RemoteConfigLongPollService;
import com.ctrip.framework.apollo.spi.ApolloInjectorCustomizer;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigFactoryManager;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.spi.DefaultConfigFactory;
import com.ctrip.framework.apollo.spi.DefaultConfigFactoryManager;
import com.ctrip.framework.apollo.spi.DefaultConfigRegistry;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.factory.DefaultPropertiesFactory;
import com.ctrip.framework.apollo.util.factory.PropertiesFactory;
import com.ctrip.framework.apollo.util.http.DefaultHttpClient;
import com.ctrip.framework.apollo.util.http.HttpClient;
import com.ctrip.framework.apollo.util.yaml.YamlParser;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.List;

public class DefaultInjector
implements Injector {
    private final com.google.inject.Injector m_injector;
    private final List<ApolloInjectorCustomizer> m_customizers;

    public DefaultInjector() {
        try {
            this.m_injector = Guice.createInjector((Module[])new Module[]{new ApolloModule()});
            this.m_customizers = ServiceBootstrap.loadAllOrdered(ApolloInjectorCustomizer.class);
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Unable to initialize Guice Injector!", ex);
            Tracer.logError((Throwable)exception);
            throw exception;
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        try {
            for (ApolloInjectorCustomizer customizer : this.m_customizers) {
                T instance = customizer.getInstance(clazz);
                if (instance == null) continue;
                return instance;
            }
            return (T)this.m_injector.getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz, String name) {
        try {
            for (ApolloInjectorCustomizer customizer : this.m_customizers) {
                T instance = customizer.getInstance(clazz, name);
                if (instance == null) continue;
                return instance;
            }
            return null;
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s with name %s!", clazz.getName(), name), ex);
        }
    }

    private static class ApolloModule
    extends AbstractModule {
        private ApolloModule() {
        }

        protected void configure() {
            this.bind(ConfigManager.class).to(DefaultConfigManager.class).in(Singleton.class);
            this.bind(ConfigFactoryManager.class).to(DefaultConfigFactoryManager.class).in(Singleton.class);
            this.bind(ConfigRegistry.class).to(DefaultConfigRegistry.class).in(Singleton.class);
            this.bind(ConfigFactory.class).to(DefaultConfigFactory.class).in(Singleton.class);
            this.bind(ConfigUtil.class).in(Singleton.class);
            this.bind(HttpClient.class).to(DefaultHttpClient.class).in(Singleton.class);
            this.bind(ConfigServiceLocator.class).in(Singleton.class);
            this.bind(RemoteConfigLongPollService.class).in(Singleton.class);
            this.bind(YamlParser.class).in(Singleton.class);
            this.bind(PropertiesFactory.class).to(DefaultPropertiesFactory.class).in(Singleton.class);
        }
    }
}

