/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.common.plugin;

import lombok.Data;

import java.util.List;

/**
 * PluginDefinition should be defined in *.jar/META-INF/plugin.yaml.
 * <p/> For example:
 *
 * <pre>
 *    name: test-plugin
 *    description: this plugin is used for test
 *    javaVersion: 1.8 or 8
 *    pluginClasses:
 *      - org.apache.inlong.plugin.TestPlugin1
 *      - org.apache.inlong.plugin.TestPlugin2
 * </pre>
 */
@Data
public class PluginDefinition {

    /**
     * Name of plugin
     */
    private String name;

    /**
     * Description of plugin to be used for user help
     */
    private String description;

    /**
     * Java version of plugin to be used for check validate
     */
    private String javaVersion;

    /**
     * List of the full class name of plugins
     */
    private List<String> pluginClasses;

}
