/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LongLiteral
extends Literal {
    private final long value;

    public LongLiteral(String value) {
        this.value = Long.parseLong(value);
    }

    public LongLiteral(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.LONG.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.LONG.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        if (dataType == TSDataType.INT32 || dataType == TSDataType.DATE) {
            try {
                Math.toIntExact(this.value);
                if (dataType == TSDataType.INT32) {
                    return true;
                }
            }
            catch (ArithmeticException e) {
                return false;
            }
            try {
                DateUtils.parseIntToLocalDate((int)((int)this.value));
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
        return dataType == TSDataType.INT64 || dataType == TSDataType.FLOAT || dataType == TSDataType.DOUBLE || dataType == TSDataType.TEXT || dataType == TSDataType.STRING || dataType == TSDataType.TIMESTAMP;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.INT64.toString();
    }

    @Override
    public int getInt() {
        return Math.toIntExact(this.value);
    }

    @Override
    public int getDate() {
        return Math.toIntExact(this.value);
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public Binary getBinary() {
        return new Binary(String.valueOf(this.value), TSFileConfig.STRING_CHARSET);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

