/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.OntModelAssembler;
import org.apache.jena.assembler.assemblers.ReasonerFactoryAssembler;
import org.apache.jena.assembler.exceptions.ReasonerClashException;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.models.ModelGetter;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.shared.NotFoundException;

@Deprecated(forRemoval=true)
public class OntModelSpecAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.OntModelSpec);
        OntModelSpec spec = new OntModelSpec(this.getDefault(root));
        OntDocumentManager dm = this.getDocumentManager(a, root);
        ReasonerFactory rf = this.getReasonerFactory(a, root);
        String lang = this.getLanguage(a, root);
        ModelGetter source = this.getModelSource(a, root);
        if (dm != null) {
            spec.setDocumentManager(dm);
        }
        if (rf != null) {
            spec.setReasonerFactory(rf);
        }
        if (lang != null) {
            spec.setLanguage(lang);
        }
        if (source != null) {
            spec.setImportModelGetter(source);
        }
        return spec;
    }

    private ModelGetter getModelSource(Assembler a, Resource root) {
        Resource source = OntModelSpecAssembler.getUniqueResource(root, JA.importSource);
        return source == null ? null : (ModelGetter)a.open(source);
    }

    private String getLanguage(Assembler a, Resource root) {
        Resource lang = OntModelSpecAssembler.getUniqueResource(root, JA.ontLanguage);
        return lang == null ? null : lang.getURI();
    }

    private ReasonerFactory getReasonerFactory(Assembler a, Resource root) {
        Resource rf = OntModelSpecAssembler.getUniqueResource(root, JA.reasonerFactory);
        Resource ru = OntModelSpecAssembler.getUniqueResource(root, JA.reasonerURL);
        if (ru != null && rf != null) {
            throw new ReasonerClashException(root);
        }
        if (ru != null) {
            return ReasonerFactoryAssembler.getReasonerFactoryByURL(root, ru);
        }
        return rf == null ? null : (ReasonerFactory)a.open(rf);
    }

    private OntDocumentManager getDocumentManager(Assembler a, Resource root) {
        Resource dm = OntModelSpecAssembler.getUniqueResource(root, JA.documentManager);
        return dm == null ? null : (OntDocumentManager)a.open(dm);
    }

    private OntModelSpec getDefault(Resource root) {
        OntModelSpec DEFAULT = OntModelAssembler.defaultSpec();
        if (root.isURIResource() && root.getNameSpace().equals("http://jena.hpl.hp.com/2005/11/Assembler#")) {
            OntModelSpec oms = OntModelSpecAssembler.getOntModelSpecField(root.getLocalName());
            return oms == null ? DEFAULT : oms;
        }
        Resource like = OntModelSpecAssembler.getUniqueResource(root, JA.likeBuiltinSpec);
        return like == null ? DEFAULT : this.getRequiredOntModelSpecField(like.getLocalName());
    }

    private OntModelSpec getRequiredOntModelSpecField(String name) {
        OntModelSpec result = OntModelSpecAssembler.getOntModelSpecField(name);
        if (result == null) {
            throw new NotFoundException(name);
        }
        return result;
    }

    public static OntModelSpec getOntModelSpecField(String name) {
        try {
            Class<OntModelSpec> omc = OntModelSpec.class;
            Field f = omc.getField(name);
            int mods = f.getModifiers();
            if (f.getType() == omc && OntModelSpecAssembler.isConstant(mods)) {
                return (OntModelSpec)f.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static boolean isConstant(int mods) {
        return Modifier.isPublic(mods) && Modifier.isFinal(mods) && Modifier.isStatic(mods);
    }
}

