/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.SplitIRI;

public class Node_URI
extends Node {
    private final String uriStr;

    protected Node_URI(String uri) {
        this.uriStr = Objects.requireNonNull(uri);
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public String getURI() {
        return this.uriStr;
    }

    @Override
    public Object visitWith(NodeVisitor v) {
        return v.visitURI(this, this.uriStr);
    }

    @Override
    public boolean isURI() {
        return true;
    }

    @Override
    public String toString() {
        return this.uriStr;
    }

    @Override
    public String toString(PrefixMapping pm) {
        String x;
        if (pm != null && (x = pm.qnameFor(this.uriStr)) != null) {
            return x;
        }
        return this.toString();
    }

    @Override
    public String getNameSpace() {
        return this.uriStr.substring(0, SplitIRI.splitXML(this.uriStr));
    }

    @Override
    public String getLocalName() {
        return this.uriStr.substring(SplitIRI.splitXML(this.uriStr));
    }

    @Override
    public boolean hasURI(String uri) {
        return this.uriStr.equals(uri);
    }

    @Override
    public int hashCode() {
        return 30 + this.uriStr.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node_URI other = (Node_URI)obj;
        return this.uriStr.equals(other.uriStr);
    }
}

