/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.shared.PrefixMapping;

public class Node_Literal
extends Node {
    private final LiteralLabel label;

    Node_Literal(LiteralLabel label) {
        this.label = Objects.requireNonNull(label);
    }

    Node_Literal(String string) {
        Objects.requireNonNull(string, "Argument to NodeFactory.createLiteral is null");
        this.label = LiteralLabelFactory.createString(string);
    }

    Node_Literal(String string, String lang) {
        Objects.requireNonNull(string, "null lexical form for literal");
        Objects.requireNonNull(lang, "null language");
        this.label = LiteralLabelFactory.createLang(string, lang);
    }

    Node_Literal(String lex, String lang, TextDirection textDir) {
        Objects.requireNonNull(lex, "null lexical form for literal");
        Objects.requireNonNull(lang, "null language");
        Objects.requireNonNull(textDir, "null base direction");
        this.label = LiteralLabelFactory.createDirLang(lex, lang, textDir);
    }

    Node_Literal(String lex, RDFDatatype dtype) {
        Objects.requireNonNull(lex, "null lexical form for literal");
        Objects.requireNonNull(dtype, "null datatype");
        this.label = LiteralLabelFactory.create(lex, dtype);
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public LiteralLabel getLiteral() {
        return this.label;
    }

    @Override
    public final Object getLiteralValue() {
        return this.getLiteral().getValue();
    }

    @Override
    public final String getLiteralLexicalForm() {
        return this.getLiteral().getLexicalForm();
    }

    @Override
    public final String getLiteralLanguage() {
        return this.getLiteral().language();
    }

    @Override
    public final TextDirection getLiteralBaseDirection() {
        return this.getLiteral().baseDirection();
    }

    @Override
    public final String getLiteralDatatypeURI() {
        return this.getLiteral().getDatatypeURI();
    }

    @Override
    public final RDFDatatype getLiteralDatatype() {
        return this.getLiteral().getDatatype();
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public Object getIndexingValue() {
        return this.getLiteral().getIndexingValue();
    }

    @Override
    public Object visitWith(NodeVisitor v) {
        return v.visitLiteral(this, this.getLiteralLexicalForm(), this.getLiteralLanguage(), this.getLiteralDatatype());
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node_Literal other = (Node_Literal)obj;
        return this.label.equals(other.label);
    }

    @Override
    public boolean sameValueAs(Node other) {
        if (other instanceof Node_Literal) {
            Node_Literal otherLiteral = (Node_Literal)other;
            return this.label.sameValueAs(otherLiteral.getLiteral());
        }
        return false;
    }

    @Override
    public String toString(PrefixMapping pm) {
        return this.label.toString(pm, true);
    }

    @Override
    public String toString() {
        return this.label.toString(PrefixMapping.Standard, true);
    }
}

