/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.mem.collection.FastHashSet;
import org.apache.jena.util.iterator.NiceIterator;

public class SparseArrayIndexedIterator<E>
extends NiceIterator<FastHashSet.IndexedKey<E>>
implements Iterator<FastHashSet.IndexedKey<E>> {
    private final E[] entries;
    private final Runnable checkForConcurrentModification;
    private int pos = 0;
    private final int toIndexExclusive;
    private boolean hasNext = false;

    public SparseArrayIndexedIterator(E[] entries, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.toIndexExclusive = entries.length;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArrayIndexedIterator(E[] entries, int toIndexExclusive, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.toIndexExclusive = toIndexExclusive;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    @Override
    public boolean hasNext() {
        while (this.toIndexExclusive > this.pos) {
            if (null != this.entries[this.pos]) {
                this.hasNext = true;
                return true;
            }
            ++this.pos;
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public FastHashSet.IndexedKey<E> next() {
        this.checkForConcurrentModification.run();
        if (this.hasNext || this.hasNext()) {
            this.hasNext = false;
            return new FastHashSet.IndexedKey<E>(this.pos, this.entries[this.pos++]);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void forEachRemaining(Consumer<? super FastHashSet.IndexedKey<E>> action) {
        while (this.toIndexExclusive > this.pos) {
            if (null != this.entries[this.pos]) {
                action.accept(new FastHashSet.IndexedKey<E>(this.pos, this.entries[this.pos]));
            }
            ++this.pos;
        }
        this.checkForConcurrentModification.run();
    }
}

