/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;

public class OWLMiniReasoner
extends GenericRuleReasoner
implements Reasoner {
    protected static final String MINI_RULE_FILE = "etc/owl-fb-mini.rules";
    protected static List<Rule> miniRuleSet;

    public static List<Rule> loadRules() {
        if (miniRuleSet == null) {
            miniRuleSet = OWLMiniReasoner.loadRules(MINI_RULE_FILE);
        }
        return miniRuleSet;
    }

    public OWLMiniReasoner(ReasonerFactory factory) {
        super(OWLMiniReasoner.loadRules(), factory);
        this.setOWLTranslation(true);
        this.setMode(HYBRID);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        InfGraph graph = super.bind(data);
        ((FBRuleInfGraph)graph).setDatatypeRangeValidation(true);
        return graph;
    }
}

