/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.FunctorDatatype;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.impl.BindingVector;
import org.apache.jena.reasoner.rulesys.impl.RETENode;
import org.apache.jena.reasoner.rulesys.impl.RETERuleContext;
import org.apache.jena.reasoner.rulesys.impl.RETESinkNode;
import org.apache.jena.reasoner.rulesys.impl.RETESourceNode;

public class RETEClauseFilter
implements RETESourceNode {
    protected byte[] instructions;
    protected Object[] args;
    protected RETESinkNode continuation;
    public static final byte TESTValue = 1;
    public static final byte TESTFunctorName = 2;
    public static final byte TESTIntraMatch = 3;
    public static final byte CREATEToken = 4;
    public static final byte BIND = 5;
    public static final byte END = 6;
    public static final byte ADDRSubject = 16;
    public static final byte ADDRPredicate = 32;
    public static final byte ADDRObject = 48;
    public static final byte ADDRFunctorNode = 64;

    public RETEClauseFilter(byte[] instructions, Object[] args) {
        this.instructions = instructions;
        this.args = args;
    }

    public static RETEClauseFilter compile(TriplePattern clause, int envLength, List<Node> varList) {
        byte[] instructions = new byte[300];
        byte[] bindInstructions = new byte[100];
        ArrayList<Object> args = new ArrayList<Object>();
        int pc = 0;
        int bpc = 0;
        bindInstructions[bpc++] = 4;
        bindInstructions[bpc++] = (byte)envLength;
        Node n = clause.getSubject();
        if (!n.isVariable()) {
            instructions[pc++] = 1;
            instructions[pc++] = 16;
            instructions[pc++] = (byte)args.size();
            args.add(n);
        } else {
            bindInstructions[bpc++] = 5;
            bindInstructions[bpc++] = 16;
            bindInstructions[bpc++] = (byte)((Node_RuleVariable)n).getIndex();
            varList.add(n);
        }
        n = clause.getPredicate();
        if (!n.isVariable()) {
            instructions[pc++] = 1;
            instructions[pc++] = 32;
            instructions[pc++] = (byte)args.size();
            args.add(clause.getPredicate());
        } else {
            bindInstructions[bpc++] = 5;
            bindInstructions[bpc++] = 32;
            bindInstructions[bpc++] = (byte)((Node_RuleVariable)n).getIndex();
            varList.add(n);
        }
        n = clause.getObject();
        if (!n.isVariable()) {
            if (Functor.isFunctor(n)) {
                Functor f = (Functor)n.getLiteralValue();
                instructions[pc++] = 2;
                instructions[pc++] = (byte)args.size();
                args.add(f.getName());
                Node[] fargs = f.getArgs();
                for (int i = 0; i < fargs.length; ++i) {
                    Node fn = fargs[i];
                    byte addr = (byte)(0x40 | 0xF & i);
                    if (!fn.isVariable()) {
                        instructions[pc++] = 1;
                        instructions[pc++] = addr;
                        instructions[pc++] = (byte)args.size();
                        args.add(fn);
                        continue;
                    }
                    bindInstructions[bpc++] = 5;
                    bindInstructions[bpc++] = addr;
                    bindInstructions[bpc++] = (byte)((Node_RuleVariable)fn).getIndex();
                    varList.add(fn);
                }
            } else {
                instructions[pc++] = 1;
                instructions[pc++] = 48;
                instructions[pc++] = (byte)args.size();
                args.add(n);
            }
        } else {
            bindInstructions[bpc++] = 5;
            bindInstructions[bpc++] = 48;
            bindInstructions[bpc++] = (byte)((Node_RuleVariable)n).getIndex();
            varList.add(n);
        }
        bindInstructions[bpc++] = 6;
        byte[] packed = new byte[pc + bpc];
        System.arraycopy(instructions, 0, packed, 0, pc);
        System.arraycopy(bindInstructions, 0, packed, pc, bpc);
        Object[] packedArgs = args.toArray();
        return new RETEClauseFilter(packed, packedArgs);
    }

    @Override
    public void setContinuation(RETESinkNode continuation) {
        this.continuation = continuation;
    }

    public void fire(Triple triple, boolean isAdd) {
        Functor lastFunctor = null;
        BindingVector env = null;
        Node n = null;
        int pc = 0;
        while (pc < this.instructions.length) {
            switch (this.instructions[pc++]) {
                case 1: {
                    Node arg1 = this.getTripleValue(triple, this.instructions[pc++], lastFunctor);
                    Object obj2 = this.args[this.instructions[pc++]];
                    if (!(obj2 instanceof Node)) {
                        return;
                    }
                    Node arg2 = (Node)obj2;
                    if (arg1.sameValueAs(arg2)) break;
                    return;
                }
                case 2: {
                    n = triple.getObject();
                    if (!n.isLiteral()) {
                        return;
                    }
                    if (n.getLiteralDatatype() != FunctorDatatype.theFunctorDatatype) {
                        return;
                    }
                    lastFunctor = (Functor)n.getLiteralValue();
                    if (lastFunctor.getName().equals(this.args[this.instructions[pc++]])) break;
                    return;
                }
                case 4: {
                    env = new BindingVector(new Node[this.instructions[pc++]]);
                    break;
                }
                case 5: {
                    n = this.getTripleValue(triple, this.instructions[pc++], lastFunctor);
                    if (env.bind(this.instructions[pc++], n)) break;
                    return;
                }
                case 6: {
                    this.continuation.fire(env, isAdd);
                }
            }
        }
    }

    private Node getTripleValue(Triple triple, byte address, Functor lastFunctor) {
        switch (address & 0xF0) {
            case 16: {
                return triple.getSubject();
            }
            case 32: {
                return triple.getPredicate();
            }
            case 48: {
                return triple.getObject();
            }
            case 64: {
                return lastFunctor.getArgs()[address & 0xF];
            }
        }
        return null;
    }

    @Override
    public RETENode clone(Map<RETENode, RETENode> netCopy, RETERuleContext context) {
        RETEClauseFilter clone = (RETEClauseFilter)netCopy.get(this);
        if (clone == null) {
            clone = new RETEClauseFilter(this.instructions, this.args);
            clone.setContinuation((RETESinkNode)this.continuation.clone(netCopy, context));
            netCopy.put(this, clone);
        }
        return clone;
    }
}

