/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.lib;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.jena.tdb2.TDBException;

public final class Async {
    private static final int THREAD_POOL_SIZE = 1;
    private static final int PENDING_MAX = 2;
    private static final int BlockingQueueSize = 4;
    private final int pendingQueueLimit;
    private final int blockingQueueSize;
    private final ExecutorService executorService;
    private final BlockingQueue<Future<Void>> outstanding;

    public Async() {
        this(1, 2);
    }

    public Async(int threadPoolSize, int pendingQueueLimit) {
        this.pendingQueueLimit = pendingQueueLimit;
        this.blockingQueueSize = this.pendingQueueLimit + 1;
        this.executorService = Executors.newFixedThreadPool(threadPoolSize);
        this.outstanding = new ArrayBlockingQueue<Future<Void>>(4);
    }

    public void completeAsyncOperations() {
        this.reduceAsyncQueue(0);
    }

    public void reduceAsyncQueue(int reduceSize) {
        while (this.outstanding.size() > reduceSize) {
            try {
                this.outstanding.take().get();
            }
            catch (Exception ex) {
                throw new TDBException("Exception taking from async queue", ex);
            }
        }
    }

    public void execAsync(Runnable action) {
        this.reduceAsyncQueue(this.pendingQueueLimit);
        Future<Void> task = this.executorService.submit(() -> {
            try {
                action.run();
            }
            catch (Exception ex) {
                throw new TDBException("Unexpected exception: " + ex.getMessage(), ex);
            }
            return null;
        });
        this.outstanding.add(task);
    }
}

