/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.match;

import org.apache.jena.atlas.lib.tuple.Tuple3;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.sys.TDBInternal;

public class MapperXTDB
implements MapperX<NodeId, Tuple3<NodeId>> {
    private NodeTable nodeTable;

    protected MapperXTDB(NodeTable nodeTable) {
        this.nodeTable = nodeTable;
    }

    public static MapperX<NodeId, Tuple3<NodeId>> create(DatasetGraph dsg) {
        DatasetGraphTDB tdb = TDBInternal.getDatasetGraphTDB(dsg);
        if (tdb == null) {
            throw new IllegalArgumentException("Argument must be a TDB2 dataset graph.");
        }
        return new MapperXTDB(tdb.getQuadTable().getNodeTupleTable().getNodeTable());
    }

    public NodeId fromNode(Node n) {
        return this.nodeTable.getNodeIdForNode(n);
    }

    public Node toNode(NodeId x) {
        return this.nodeTable.getNodeForNodeId(x);
    }

    public NodeId subject(Tuple3<NodeId> tuple) {
        return (NodeId)tuple.get(0);
    }

    public NodeId predicate(Tuple3<NodeId> tuple) {
        return (NodeId)tuple.get(1);
    }

    public NodeId object(Tuple3<NodeId> tuple) {
        return (NodeId)tuple.get(2);
    }

    public Tuple3<NodeId> tuple(NodeId s, NodeId p, NodeId o) {
        return TupleFactory.create3((Object)s, (Object)p, (Object)o);
    }
}

