/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml.rrx_stax_sr;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.rdfxml.RDFXMLParseException;
import org.apache.jena.riot.lang.rdfxml.rrx_stax_sr.ReaderRDFXML_StAX_SR;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.XML11Char;
import org.apache.jena.vocabulary.RDF;

class ParserRRX_StAX_SR {
    private static int IRI_CACHE_SIZE = 8192;
    private static boolean EVENTS = false;
    private final IndentedWriter trace;
    private final XMLStreamReader xmlSource;
    private Cache<String, IRIx> iriCacheForBaseNull = null;
    private Cache<String, IRIx> currentIriCache = null;
    private final Map<IRIx, Cache<String, IRIx>> mapBaseIriToCache = new HashMap<IRIx, Cache<String, IRIx>>();
    private static final String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String xmlNS = "http://www.w3.org/XML/1998/namespace";
    private boolean hasRDF = false;
    private final ParserProfile parserProfile;
    private final ErrorHandler errorHandler;
    private final StreamRDF destination;
    private Deque<BaseLang> stack = new ArrayDeque<BaseLang>();
    private int countTrackingIDs = 0;
    private Map<IRIx, Map<String, Location>> trackUsedIDs = new HashMap<IRIx, Map<String, Location>>();
    private StringBuilder accCharacters = new StringBuilder(100);
    private IRIx currentBase = null;
    private String currentLang = null;
    private static final QName rdfRDF = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
    private static final QName rdfDescription = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
    private static final QName rdfID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
    private static final QName rdfNodeID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
    private static final QName rdfAbout = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
    private static final QName rdfType = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
    private static final QName rdfContainerItem = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li");
    private static final QName rdfDatatype = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
    private static final QName rdfParseType = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
    private static final QName rdfResource = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
    private static final QName rdfAboutEach = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEach");
    private static final QName rdfAboutEachPrefix = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEachPrefix");
    private static final QName rdfBagID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
    private static final QName xmlQNameBase = new QName("http://www.w3.org/XML/1998/namespace", "base");
    private static final QName xmlQNameLang = new QName("http://www.w3.org/XML/1998/namespace", "lang");
    private static final QName xmlQNameSpace = new QName("http://www.w3.org/XML/1998/namespace", "space");
    private static final String parseTypeCollection = "Collection";
    private static final String parseTypeLiteral = "Literal";
    private static final String parseTypeLiteralAlt = "literal";
    private static final String parseTypeLiteralStmts = "Statements";
    private static final String parseTypeResource = "Resource";
    private static final String parseTypePlain = "$$";
    private static Set<QName> $coreSyntaxTerms = Set.of(rdfRDF, rdfID, rdfAbout, rdfParseType, rdfResource, rdfNodeID, rdfDatatype);
    private static Set<QName> $syntaxTerms = Set.of(rdfRDF, rdfID, rdfAbout, rdfParseType, rdfResource, rdfNodeID, rdfDatatype, rdfDescription, rdfContainerItem);
    private static Set<QName> $oldTerms = Set.of(rdfAboutEach, rdfAboutEachPrefix, rdfBagID);
    private static Set<String> $allowedUnqualified = Set.of(rdfAbout.getLocalPart(), rdfID.getLocalPart(), rdfResource.getLocalPart(), rdfParseType.getLocalPart(), rdfType.getLocalPart());
    private static Set<QName> $rdfSyntaxAttributes = Set.of(rdfRDF, rdfAbout, rdfNodeID, rdfID, rdfParseType, rdfDatatype, rdfResource);
    private static Set<QName> $xmlReservedTerms = Set.of(xmlQNameBase, xmlQNameLang, xmlQNameSpace);
    private static final String openStartTag = "<";
    private static final String closeStartTag = ">";
    private static final String openEndTag = "</";
    private static final String closeEndTag = ">";
    private static final Set<String> knownRDF = Set.of("Bag", "Seq", "Alt", "List", "XMLLiteral", "Property", "Statement", "type", "li", "subject", "predicate", "object", "value", "first", "rest", "nil");
    private static final Set<String> knownRDFProperties = knownRDF;
    private static final Set<String> knownRDFTypes = knownRDF;

    private void updateCurrentIriCacheForCurrentBase() {
        if (this.currentBase != null) {
            this.currentIriCache = this.mapBaseIriToCache.computeIfAbsent(this.currentBase, b -> CacheFactory.createSimpleCache((int)IRI_CACHE_SIZE));
        } else {
            if (this.iriCacheForBaseNull == null) {
                this.iriCacheForBaseNull = CacheFactory.createSimpleCache((int)IRI_CACHE_SIZE);
            }
            this.currentIriCache = this.iriCacheForBaseNull;
        }
    }

    private boolean isDifferentFromCurrentBase(IRIx base) {
        if (this.currentBase != null) {
            return !this.currentBase.equals((Object)base);
        }
        return base != null;
    }

    private void pushFrame(IRIx base, String lang) {
        BaseLang frame = new BaseLang(this.currentBase, this.currentLang, this.currentIriCache);
        this.stack.push(frame);
        this.currentLang = lang;
        if (this.isDifferentFromCurrentBase(base)) {
            this.currentBase = base;
            this.updateCurrentIriCacheForCurrentBase();
        }
    }

    private void popFrame() {
        BaseLang frame = this.stack.pop();
        this.currentLang = frame.lang;
        if (this.isDifferentFromCurrentBase(frame.base)) {
            this.currentBase = frame.base;
            this.currentIriCache = frame.iriCache;
        }
    }

    private RiotException RDFXMLparseError(String message) {
        return this.RDFXMLparseError(message, this.location());
    }

    private void RDFXMLparseWarning(String message) {
        this.RDFXMLparseWarning(message, this.location());
    }

    private RiotException RDFXMLparseError(String message, Location location) {
        if (location != null) {
            this.errorHandler.error(message, location.getLineNumber(), location.getColumnNumber());
        } else {
            this.errorHandler.error(message, -1L, -1L);
        }
        return new RiotException(SysRIOT.fmtMessage(message, location.getLineNumber(), location.getColumnNumber()));
    }

    private void RDFXMLparseWarning(String message, Location location) {
        if (location != null) {
            this.errorHandler.warning(message, location.getLineNumber(), location.getColumnNumber());
        } else {
            this.errorHandler.warning(message, -1L, -1L);
        }
    }

    private Location previousUseOfID(String idStr, Location location) {
        Map scope = this.trackUsedIDs.computeIfAbsent(this.currentBase, k -> new HashMap());
        Location prev = (Location)scope.get(idStr);
        if (prev != null) {
            return prev;
        }
        if (this.countTrackingIDs > 10000) {
            return null;
        }
        scope.put(idStr, location);
        ++this.countTrackingIDs;
        return null;
    }

    ParserRRX_StAX_SR(XMLStreamReader reader, String xmlBase, ParserProfile parserProfile, StreamRDF destination, Context context2) {
        IndentedWriter out = IndentedWriter.stdout.clone();
        out.setFlushOnNewline(true);
        out.setUnitIndent(4);
        out.setLinePrefix("# ");
        this.trace = out;
        EVENTS = ReaderRDFXML_StAX_SR.TRACE;
        this.xmlSource = reader;
        this.parserProfile = parserProfile;
        this.errorHandler = parserProfile.getErrorHandler();
        if (xmlBase != null) {
            this.currentBase = IRIx.create((String)xmlBase);
            parserProfile.setBaseIRI(this.currentBase.str());
        } else {
            this.currentBase = null;
        }
        this.updateCurrentIriCacheForCurrentBase();
        this.currentLang = "";
        this.destination = destination;
    }

    private boolean coreSyntaxTerm(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return false;
        }
        return $coreSyntaxTerms.contains(qName);
    }

    private static boolean allowedNodeElementURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfContainerItem.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedPropertyElementURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfDescription.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedPropertyAttributeURIs(QName qName) {
        if (!rdfNS.equals(qName.getNamespaceURI())) {
            return true;
        }
        if ($coreSyntaxTerms.contains(qName)) {
            return false;
        }
        if (rdfDescription.equals(qName)) {
            return false;
        }
        if (rdfContainerItem.equals(qName)) {
            return false;
        }
        return !$oldTerms.contains(qName);
    }

    private static boolean allowedUnqualifiedTerm(String localName) {
        return $allowedUnqualified.contains(localName);
    }

    private static boolean isSyntaxAttribute(QName qName) {
        return $rdfSyntaxAttributes.contains(qName);
    }

    private static boolean isXMLQName(QName qName) {
        return $xmlReservedTerms.contains(qName);
    }

    private static boolean isXMLNamespace(QName qName) {
        return xmlNS.equals(qName.getNamespaceURI());
    }

    void parse() {
        int eventType = this.nextEventAny();
        if (ParserRRX_StAX_SR.lookingAt(eventType, 8)) {
            throw this.RDFXMLparseError("Empty document", this.location());
        }
        if (ParserRRX_StAX_SR.lookingAt(eventType, 11)) {
            eventType = this.nextEventTag();
        }
        if (!ParserRRX_StAX_SR.lookingAt(eventType, 1)) {
            throw this.RDFXMLparseError("Not a start element: " + this.strEventType(eventType), this.location());
        }
        boolean hasFrame = false;
        if (this.qNameMatches(rdfRDF, this.qName())) {
            if (ReaderRDFXML_StAX_SR.TRACE) {
                this.trace.println("rdf:RDF");
            }
            hasFrame = this.startElement();
            this.emitInitialBaseAndNamespaces();
            this.hasRDF = true;
            eventType = this.nextEventTag();
        }
        this.incIndent();
        if (this.hasRDF) {
            this.nodeElementLoop(eventType);
        } else {
            this.nodeElementSingle(eventType);
        }
        this.decIndent();
        if (this.hasRDF) {
            this.endElement(hasFrame);
            if (ReaderRDFXML_StAX_SR.TRACE) {
                this.trace.println("/rdf:RDF");
            }
            eventType = this.nextEventAny();
        }
        while (this.isWhitespace(eventType)) {
            eventType = this.nextEventAny();
        }
    }

    private void nodeElementLoop(int eventType) {
        while (eventType >= 0 && ParserRRX_StAX_SR.lookingAt(eventType, 1)) {
            this.nodeElement();
            eventType = this.nextEventTag();
        }
    }

    private void nodeElementSingle(int eventType) {
        if (!ParserRRX_StAX_SR.lookingAt(eventType, 1)) {
            return;
        }
        this.nodeElement();
    }

    private void nodeElement() {
        this.nodeElement(null);
    }

    private void nodeElement(Node subject) {
        QName qName = this.qName();
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.println(">> nodeElement: " + ParserRRX_StAX_SR.str(this.location()) + " " + ParserRRX_StAX_SR.str(qName));
        }
        if (!ParserRRX_StAX_SR.allowedNodeElementURIs(qName)) {
            throw this.RDFXMLparseError("Not allowed as a node element tag: '" + ParserRRX_StAX_SR.str(qName) + "'");
        }
        String rdfResourceStr = this.attribute(rdfResource);
        if (rdfResourceStr != null) {
            throw this.RDFXMLparseError("rdf:resource not allowed as attribute here: " + ParserRRX_StAX_SR.str(qName));
        }
        this.incIndent();
        boolean hasFrame = this.startElement();
        if (subject == null) {
            subject = this.attributesToSubjectNode();
        }
        this.nodeElementProcess(subject);
        this.endElement(hasFrame);
        this.decIndent();
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.println("<< nodeElement: " + ParserRRX_StAX_SR.str(this.location()) + " " + this.strEventType(this.eventType()));
        }
    }

    private void nodeElementProcess(Node subject) {
        QName qName = this.qName();
        Location location = this.location();
        if (!this.qNameMatches(qName, rdfDescription)) {
            if (ParserRRX_StAX_SR.isMemberProperty(qName)) {
                this.RDFXMLparseWarning(ParserRRX_StAX_SR.str(qName) + " is being used on a typed node");
            } else if (this.isNotRecognizedRDFtype(qName)) {
                this.RDFXMLparseWarning(ParserRRX_StAX_SR.str(qName) + " is not a recognized RDF term for a type");
            }
            Node object = this.qNameToIRI(qName, QNameUsage.TypedNodeElement, location);
            this.emit(subject, NodeConst.nodeRDFType, object, location);
        }
        this.processPropertyAttributes(subject, qName, false, location);
        int event = this.nextEventTag();
        event = this.propertyElementlLoop(subject, event);
        if (!ParserRRX_StAX_SR.lookingAt(event, 2)) {
            throw this.RDFXMLparseError("Expected end element for " + String.valueOf(this.qName()));
        }
    }

    private int propertyElementlLoop(Node subject, int event) {
        Counter listElementCounter = new Counter();
        while (ParserRRX_StAX_SR.lookingAt(event, 1)) {
            this.propertyElement(subject, listElementCounter, this.location());
            event = this.nextEventTag();
        }
        return event;
    }

    private void propertyElement(Node subject, Counter listElementCounter, Location location) {
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.println(">> propertyElement: " + ParserRRX_StAX_SR.str(this.location()) + " " + ParserRRX_StAX_SR.str(this.qName()));
        }
        this.incIndent();
        boolean hasFrame = this.startElement();
        QName qName = this.qName();
        if (!ParserRRX_StAX_SR.allowedPropertyElementURIs(qName)) {
            throw this.RDFXMLparseError("QName not allowed for property: " + ParserRRX_StAX_SR.str(qName));
        }
        if (this.isNotRecognizedRDFproperty(qName)) {
            this.RDFXMLparseWarning(ParserRRX_StAX_SR.str(qName) + " is not a recognized RDF property");
        }
        this.propertyElementProcess(subject, qName, listElementCounter, location);
        this.endElement(hasFrame);
        this.decIndent();
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.println("<< propertyElement: " + ParserRRX_StAX_SR.str(this.location()) + " " + ParserRRX_StAX_SR.str(qName));
        }
    }

    private int propertyElementProcess(Node subject, QName qName, Counter listElementCounter, Location location) {
        Node property = this.qNameMatches(rdfContainerItem, qName) ? this.iriDirect("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + Integer.toString(listElementCounter.value++), this.location()) : this.qNameToIRI(qName, QNameUsage.PropertyElement, location);
        Node reify = this.reifyStatement(location);
        Emitter emitter = reify == null ? this::emit : (s, p, o, loc) -> this.emitReify(reify, s, p, o, loc);
        String objBlankNodeLabel = this.attribute(rdfNodeID);
        String rdfResourceStr = this.attribute(rdfResource);
        String datatype = this.attribute(rdfDatatype);
        String parseType = this.objectParseType();
        if (datatype != null) {
            if (parseType != null && parseType != parseTypePlain) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:parseType.");
            }
            if (rdfResourceStr != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:resource.");
            }
            if (objBlankNodeLabel != null) {
                throw this.RDFXMLparseError("rdf:datatype can not be used with rdf:NodeId.");
            }
        }
        if (rdfResourceStr != null && objBlankNodeLabel != null) {
            throw this.RDFXMLparseError("Can't have both rdf:nodeId and rdf:resource on a property element");
        }
        if (rdfResourceStr != null && parseType != parseTypePlain) {
            throw this.RDFXMLparseError("Both rdf:resource and rdf:ParseType on a property element. Only one allowed");
        }
        if (objBlankNodeLabel != null && parseType != parseTypePlain) {
            throw this.RDFXMLparseError("Both rdf:NodeId and rdf:ParseType on a property element. Only one allowed");
        }
        Node resourceObj = null;
        if (rdfResourceStr != null) {
            resourceObj = this.iriResolve(rdfResourceStr, location);
        }
        if (objBlankNodeLabel != null) {
            resourceObj = this.blankNode(objBlankNodeLabel, location);
        }
        Node innerSubject = this.processPropertyAttributes(resourceObj, qName, true, location);
        if (resourceObj == null && innerSubject != null) {
            emitter.emit(subject, property, innerSubject, location);
            int event = this.nextEventAny();
            if (!ParserRRX_StAX_SR.lookingAt(event, 2)) {
                throw this.RDFXMLparseError("Expecting end element tag when using property attributes on a property element");
            }
            return event;
        }
        if (resourceObj != null) {
            emitter.emit(subject, property, resourceObj, location);
            int event = this.nextEventAny();
            if (!ParserRRX_StAX_SR.lookingAt(event, 2)) {
                throw this.RDFXMLparseError("Expecting end element tag when using rdf:resource or rdf:NodeId on a property.");
            }
            return event;
        }
        switch (switch (parseTypeName = parseType) {
            case parseTypeLiteralAlt -> {
                this.RDFXMLparseWarning("Encountered rdf:parseType='literal'. Treated as rdf:parseType='Literal'", this.location());
                yield parseTypeLiteral;
            }
            case parseTypeLiteralStmts -> {
                this.RDFXMLparseWarning("Encountered rdf:parseType='Statements'. Treated as rdf:parseType='Literal'", this.location());
                yield parseTypeLiteral;
            }
        }) {
            case "Resource": {
                if (ReaderRDFXML_StAX_SR.TRACE) {
                    this.trace.println("rdfParseType=Resource");
                }
                int event = this.parseTypeResource(subject, property, emitter, location);
                return event;
            }
            case "Literal": {
                if (ReaderRDFXML_StAX_SR.TRACE) {
                    this.trace.println("rdfParseType=Literal");
                }
                int event = this.parseTypeLiteral(subject, property, emitter, location);
                return event;
            }
            case "Collection": {
                if (ReaderRDFXML_StAX_SR.TRACE) {
                    this.trace.println("rdfParseType=Collection");
                }
                int event = this.parseTypeCollection(subject, property, emitter, location);
                return event;
            }
            case "$$": {
                break;
            }
            default: {
                throw this.RDFXMLparseError("Not a legal defined rdf:parseType: " + parseType);
            }
        }
        int event = this.nextEventAny();
        if (ParserRRX_StAX_SR.lookingAt(event, 4)) {
            this.accCharacters.setLength(0);
            while (ParserRRX_StAX_SR.lookingAt(event, 4)) {
                String text = this.xmlSource.getText();
                this.accCharacters.append(text);
                event = this.nextEventAny();
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 1)) {
                if (!ParserRRX_StAX_SR.isWhitespace(this.accCharacters)) {
                    String msg = ParserRRX_StAX_SR.nonWhitespaceMsg(this.accCharacters.toString());
                    throw this.RDFXMLparseError("Content before node element. '" + msg + "'");
                }
                event = this.processNestedNodeElement(event, subject, property, emitter);
                return event;
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 2)) {
                String lexicalForm = this.accCharacters.toString();
                Location loc2 = this.location();
                Node obj = datatype != null ? this.literalDatatype(lexicalForm, datatype, loc2) : (this.currentLang() != null ? this.literal(lexicalForm, this.currentLang, loc2) : this.literal(lexicalForm, loc2));
                emitter.emit(subject, property, obj, loc2);
                return event;
            }
            throw this.RDFXMLparseError("Unexpected element: " + this.strEventType(event));
        }
        if (ParserRRX_StAX_SR.lookingAt(event, 1)) {
            event = this.processNestedNodeElement(event, subject, property, emitter);
            return event;
        }
        if (!ParserRRX_StAX_SR.lookingAt(event, 2)) {
            throw this.RDFXMLparseError("Malformed property. " + this.strEventType(event));
        }
        emitter.emit(subject, property, NodeConst.emptyString, location);
        return event;
    }

    private Node processPropertyAttributes(Node resourceObj, QName qName, boolean isPropertyElement, Location location) {
        String parseTypeStr;
        List<Integer> indexes = this.gatherPropertyAttributes(location);
        if (indexes.isEmpty()) {
            return null;
        }
        if (isPropertyElement && (parseTypeStr = this.objectParseType()) != parseTypePlain) {
            throw this.RDFXMLparseError("The attribute rdf:parseType is not permitted with property attributes on a property element: " + ParserRRX_StAX_SR.str(qName), location);
        }
        Node innerSubject = resourceObj == null ? this.blankNode(location) : resourceObj;
        this.outputPropertyAttributes(innerSubject, indexes, location);
        return innerSubject;
    }

    private List<Integer> gatherPropertyAttributes(Location location) {
        int N = this.xmlSource.getAttributeCount();
        if (N == 0) {
            return List.of();
        }
        ArrayList<Integer> attributeIdx = new ArrayList<Integer>(N);
        for (int idx = 0; idx < N; ++idx) {
            QName qName = this.xmlSource.getAttributeName(idx);
            boolean isPropertyAttribute = this.checkPropertyAttribute(qName, location);
            if (!isPropertyAttribute) continue;
            attributeIdx.add(idx);
        }
        return attributeIdx;
    }

    private void outputPropertyAttributes(Node subject, List<Integer> indexes, Location location) {
        for (int index : indexes) {
            QName qName = this.xmlSource.getAttributeName(index);
            if (rdfType.equals(qName)) {
                String iriStr = this.xmlSource.getAttributeValue(index);
                Node type = this.iriResolve(iriStr, location);
                this.emit(subject, RDF.Nodes.type, type, location);
                return;
            }
            Node property = this.attributeToIRI(qName, location);
            String lexicalForm = this.xmlSource.getAttributeValue(index);
            Node object = this.literal(lexicalForm, this.currentLang, location);
            this.emit(subject, property, object, location);
        }
    }

    private boolean checkPropertyAttribute(QName qName, Location location) {
        if (ParserRRX_StAX_SR.isSyntaxAttribute(qName)) {
            return false;
        }
        if (this.coreSyntaxTerm(qName)) {
            return false;
        }
        if (!ParserRRX_StAX_SR.allowedPropertyAttributeURIs(qName)) {
            throw this.RDFXMLparseError("Not allowed as a property attribute: '" + ParserRRX_StAX_SR.str(qName) + "'");
        }
        if (this.isNotRecognizedRDFproperty(qName)) {
            this.RDFXMLparseWarning(ParserRRX_StAX_SR.str(qName) + " is not a recognized RDF term for a property attribute");
        }
        if (ParserRRX_StAX_SR.isXMLQName(qName)) {
            return false;
        }
        if (ParserRRX_StAX_SR.isXMLNamespace(qName)) {
            this.RDFXMLparseWarning("Unrecognized XML attribute: '" + ParserRRX_StAX_SR.str(qName) + "'");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)qName.getNamespaceURI())) {
            String localName = qName.getLocalPart();
            boolean valid = this.checkPropertyAttributeUnqualifiedTerm(localName, location);
            return valid;
        }
        return true;
    }

    private boolean checkPropertyAttributeUnqualifiedTerm(String localName, Location location) {
        String chars3;
        if (ParserRRX_StAX_SR.allowedUnqualifiedTerm(localName)) {
            return true;
        }
        if (localName.length() >= 3 && (chars3 = localName.substring(0, 3)).equalsIgnoreCase("xml")) {
            this.RDFXMLparseWarning("Unrecognized XML non-namespaced attribute '" + localName + "' - ignored", location);
            return false;
        }
        throw this.RDFXMLparseError("Non-namespaced attribute not allowed as a property attribute: '" + localName + "'", location);
    }

    private String objectParseType() {
        String parseTypeStr = this.attribute(rdfParseType);
        return parseTypeStr != null ? parseTypeStr : parseTypePlain;
    }

    private String accumulateLexicalForm(int initialEvent, StringBuilder sBuff) {
        int eventType = initialEvent;
        while (eventType >= 0 && !ParserRRX_StAX_SR.lookingAt(eventType, 2)) {
            if (!ParserRRX_StAX_SR.lookingAt(eventType, 4)) {
                throw this.RDFXMLparseError("Unexpected element in text element: " + this.strEventType(eventType));
            }
            sBuff.append(this.xmlSource.getText());
            eventType = this.nextEventAny();
        }
        String lexicalForm = sBuff.toString();
        return lexicalForm;
    }

    private int parseTypeResource(Node subject, Node property, Emitter emitter, Location location) {
        Node innerSubject = this.blankNode(location);
        emitter.emit(subject, property, innerSubject, location);
        int event = this.nextEventTag();
        event = this.propertyElementlLoop(innerSubject, event);
        return event;
    }

    private int parseTypeLiteral(Node subject, Node property, Emitter emitter, Location location) {
        String text = this.xmlLiteralAccumulateText();
        Node object = this.literalDatatype(text, RDF.dtXMLLiteral, location);
        emitter.emit(subject, property, object, location);
        return 2;
    }

    private String xmlLiteralAccumulateText() {
        Map namespaces = Map.of();
        ArrayDeque<Map> stackNamespaces = new ArrayDeque<Map>();
        this.accCharacters.setLength(0);
        StringBuilder sBuff = this.accCharacters;
        int event = 1;
        int depth = 0;
        while (event >= 0) {
            QName qname;
            event = this.nextEventRaw();
            if (ParserRRX_StAX_SR.lookingAt(event, 1)) {
                ++depth;
                this.incIndent();
                stackNamespaces.push(namespaces);
                namespaces = new HashMap(namespaces);
                sBuff.append(openStartTag);
                qname = this.qName();
                if (qname.getPrefix() != null && !"".equals(qname.getPrefix())) {
                    sBuff.append(qname.getPrefix());
                    sBuff.append(":");
                }
                sBuff.append(qname.getLocalPart());
                this.xmlLiteralNamespaces(namespaces, sBuff);
                this.xmlLiteralAttributes(sBuff);
                sBuff.append(">");
                continue;
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 2)) {
                this.decIndent();
                if (--depth < 0) break;
                namespaces = (Map)stackNamespaces.pop();
                sBuff.append(openEndTag);
                qname = this.qName();
                if (qname.getPrefix() != null && !"".equals(qname.getPrefix())) {
                    sBuff.append(this.xmlSource.getPrefix());
                    sBuff.append(":");
                }
                sBuff.append(qname.getLocalPart());
                sBuff.append(">");
                continue;
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 4)) {
                String s = this.xmlSource.getText();
                s = this.xmlLiteralEscapeText(s);
                sBuff.append(s);
                continue;
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 5)) {
                String commentText = this.xmlSource.getText();
                sBuff.append("<!--");
                sBuff.append(commentText);
                sBuff.append("-->");
                continue;
            }
            if (ParserRRX_StAX_SR.lookingAt(event, 3)) {
                String target = this.xmlSource.getPITarget();
                String data = this.xmlSource.getPIData();
                this.accCharacters.append("<?");
                this.accCharacters.append(target);
                this.accCharacters.append(' ');
                this.accCharacters.append(data);
                this.accCharacters.append("?>");
                continue;
            }
            throw this.RDFXMLparseError("Unexpected event in rdf:XMLLiteral: " + this.strEventType(event));
        }
        String x = sBuff.toString();
        this.accCharacters.setLength(0);
        return x;
    }

    private void xmlLiteralAttributes(StringBuilder sBuff) {
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        int N = this.xmlSource.getAttributeCount();
        for (int i = 0; i < N; ++i) {
            String value = this.xmlSource.getAttributeValue(i);
            QName qName = this.xmlSource.getAttributeName(i);
            String attrName = ParserRRX_StAX_SR.str(qName);
            attrs.put(attrName, value);
        }
        for (Map.Entry e2 : attrs.entrySet()) {
            String attrQName = (String)e2.getKey();
            String attrValue = (String)e2.getValue();
            sBuff.append(" ");
            sBuff.append(attrQName);
            sBuff.append("=\"");
            sBuff.append(this.xmlLiteralEscapeAttr(attrValue));
            sBuff.append("\"");
        }
    }

    private void xmlLiteralNamespaces(Map<String, String> namespaces, StringBuilder sBuff) {
        NamespaceContext nsCxt = this.xmlSource.getNamespaceContext();
        TreeMap<String, String> outputNS = new TreeMap<String, String>();
        this.xmlLiteralNamespaceQName(outputNS, namespaces, nsCxt, this.qName());
        int N = this.xmlSource.getAttributeCount();
        for (int i = 0; i < N; ++i) {
            this.xmlLiteralNamespaceQName(outputNS, namespaces, nsCxt, this.xmlSource.getAttributeName(i));
        }
        for (String prefix : outputNS.keySet()) {
            String uri = (String)outputNS.get(prefix);
            if (uri == null) continue;
            sBuff.append(" ");
            if (prefix.isEmpty()) {
                sBuff.append("xmlns=\"");
                sBuff.append(uri);
                sBuff.append("\"");
                continue;
            }
            sBuff.append("xmlns:");
            sBuff.append(prefix);
            sBuff.append("=\"");
            sBuff.append(uri);
            sBuff.append("\"");
        }
    }

    private void xmlLiteralNamespaceQName(Map<String, String> outputNS, Map<String, String> namespaces, NamespaceContext nsCxt, QName qName) {
        String prefix = qName.getPrefix();
        String namespaceURI = nsCxt.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            // empty if block
        }
        if (namespaceURI != "" && (!namespaces.containsKey(prefix) || namespaceURI != null && !namespaces.get(prefix).equals(namespaceURI))) {
            outputNS.put(prefix, namespaceURI);
            namespaces.put(prefix, namespaceURI);
        }
    }

    private String xmlLiteralEscapeText(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '>': {
                    String string = "&gt;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    private String xmlLiteralEscapeAttr(CharSequence stringAcc) {
        StringBuilder sBuff = new StringBuilder();
        int len = stringAcc.length();
        for (int i = 0; i < len; ++i) {
            String replace;
            char c = stringAcc.charAt(i);
            switch (c) {
                case '&': {
                    String string = "&amp;";
                    break;
                }
                case '<': {
                    String string = "&lt;";
                    break;
                }
                case '\"': {
                    String string = "&quot;";
                    break;
                }
                default: {
                    String string = replace = null;
                }
            }
            if (replace == null) {
                sBuff.append(c);
                continue;
            }
            sBuff.append(replace);
        }
        return sBuff.toString();
    }

    private int parseTypeCollection(Node subject, Node property, Emitter emitter, Location location) {
        Node lastCell = null;
        int event = -1;
        while (ParserRRX_StAX_SR.lookingAt(event = this.nextEventTag(), 1)) {
            location = this.location();
            Node thisCell = this.blankNode(location);
            if (lastCell == null) {
                lastCell = thisCell;
                emitter.emit(subject, property, thisCell, location);
            } else {
                this.emit(lastCell, NodeConst.nodeRest, thisCell, location);
            }
            Node itemSubject = this.attributesToSubjectNode();
            this.emit(thisCell, RDF.Nodes.first, itemSubject, location);
            this.nodeElement(itemSubject);
            lastCell = thisCell;
        }
        if (lastCell != null) {
            this.emit(lastCell, NodeConst.nodeRest, NodeConst.nodeNil, location);
        } else {
            emitter.emit(subject, property, NodeConst.nodeNil, location);
        }
        return event;
    }

    private Node reifyStatement(Location location) {
        String reifyId = this.attribute(rdfID);
        if (reifyId == null) {
            return null;
        }
        Node reify = this.iriFromID(reifyId, location);
        return reify;
    }

    private String currentLang() {
        if (this.currentLang == null || this.currentLang.isEmpty()) {
            return null;
        }
        return this.currentLang;
    }

    private int processNestedNodeElement(int event, Node subject, Node property, Emitter emitter) {
        boolean hasFrame = this.startElement();
        Node subjectInner = this.attributesToSubjectNode();
        emitter.emit(subject, property, subjectInner, this.location());
        this.nodeElement(subjectInner);
        int eventType = this.nextEventTag();
        if (ParserRRX_StAX_SR.lookingAt(eventType, 1)) {
            throw this.RDFXMLparseError("Start tag after inner node element (only one node element permitted): got " + String.valueOf(this.qName()));
        }
        if (!ParserRRX_StAX_SR.lookingAt(eventType, 2)) {
            throw this.RDFXMLparseError("Expected an end element: got " + this.strEventType(eventType));
        }
        this.endElement(hasFrame);
        return event;
    }

    private Node attributesToSubjectNode() {
        String iriStr = this.attribute(rdfAbout);
        String idStr = this.attribute(rdfID);
        String nodeId = this.attribute(rdfNodeID);
        if (nodeId != null && iriStr != null && nodeId != null) {
            throw this.RDFXMLparseError("All of rdf:about, rdf:NodeId and rdf:ID found. Must be only one.");
        }
        if (iriStr != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:ID found. Must be only one.");
        }
        if (nodeId != null && iriStr != null) {
            throw this.RDFXMLparseError("Both rdf:about and rdf:NodeID found. Must be only one.");
        }
        if (nodeId != null && idStr != null) {
            throw this.RDFXMLparseError("Both rdf:NodeID rdf:ID found. Must be only one.");
        }
        Location location = this.location();
        if (iriStr != null) {
            return this.iriResolve(iriStr, location);
        }
        if (idStr != null) {
            return this.iriFromID(idStr, location);
        }
        if (nodeId != null) {
            return this.blankNode(nodeId, location);
        }
        return this.blankNode(location);
    }

    private Node qNameToIRI(QName qName, QNameUsage usage, Location location) {
        if (StringUtils.isBlank((CharSequence)qName.getNamespaceURI())) {
            throw this.RDFXMLparseError("Unqualified " + usage.msg + " not allowed: <" + qName.getLocalPart() + ">", location);
        }
        String uriStr = this.strQNameToIRI(qName);
        return this.iriDirect(uriStr, location);
    }

    private String strQNameToIRI(QName qName) {
        return qName.getNamespaceURI() + qName.getLocalPart();
    }

    private Node attributeToIRI(QName qName, Location location) {
        String namespaceURI = qName.getNamespaceURI();
        String localName = qName.getLocalPart();
        if (StringUtils.isBlank((CharSequence)namespaceURI)) {
            if (ParserRRX_StAX_SR.allowedUnqualifiedTerm(localName)) {
                namespaceURI = rdfNS;
            } else {
                throw this.RDFXMLparseError("Unqualified property attribute not allowed: '" + localName + "'", location);
            }
        }
        String uriStr = namespaceURI + localName;
        return this.iriDirect(uriStr, location);
    }

    private String attribute(QName qName) {
        return this.xmlSource.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
    }

    private RiotException handleXMLStreamException(XMLStreamException ex) {
        String msg = this.xmlStreamExceptionMessage(ex);
        if (ex.getLocation() != null) {
            int line = ex.getLocation().getLineNumber();
            int col = ex.getLocation().getColumnNumber();
            this.errorHandler.fatal(msg, line, col);
        } else {
            this.errorHandler.fatal(msg, -1L, -1L);
        }
        return new RiotException(ex.getMessage(), ex);
    }

    private String xmlStreamExceptionMessage(XMLStreamException ex) {
        String marker;
        int i;
        String msg = ex.getMessage();
        if (ex.getLocation() != null && (i = msg.indexOf(marker = "\nMessage: ")) > 0) {
            msg = msg.substring(i + marker.length());
        }
        return msg;
    }

    private int eventType() {
        return this.xmlSource.getEventType();
    }

    private QName qName() {
        return this.xmlSource.getName();
    }

    private static boolean lookingAt(int eventType, int expectedEventType) {
        return eventType == expectedEventType;
    }

    private Location location() {
        return this.xmlSource.getLocation();
    }

    private int nextEventTag() {
        try {
            block7: while (this.xmlSource.hasNext()) {
                int evType = this.read();
                switch (evType) {
                    case 1: 
                    case 2: {
                        if (EVENTS) {
                            System.out.println("-- Tag: " + this.strEventType(evType));
                        }
                        return evType;
                    }
                    case 4: 
                    case 12: {
                        String chars = this.xmlSource.getText();
                        if (ParserRRX_StAX_SR.isWhitespace(chars)) continue block7;
                        String text = ParserRRX_StAX_SR.nonWhitespaceMsg(chars);
                        throw this.RDFXMLparseError("Expecting a start or end element. Got characters '" + text + "'");
                    }
                    case 5: 
                    case 11: {
                        continue block7;
                    }
                }
                throw this.RDFXMLparseError("Unexpected  event " + this.strEventType(evType));
            }
            return -1;
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private int nextEventAny() {
        try {
            int ev = -1;
            while (this.xmlSource.hasNext()) {
                ev = this.read();
                if (ParserRRX_StAX_SR.isComment(ev)) continue;
                if (!ParserRRX_StAX_SR.lookingAt(ev, 3)) break;
                this.RDFXMLparseWarning("XML Processing instruction - ignored");
            }
            if (EVENTS) {
                if (ev < 0) {
                    System.out.println("-- Read: end of events");
                } else {
                    System.out.println("-- Event: " + this.strEventType(ev));
                }
            }
            return ev;
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private int nextEventRaw() {
        try {
            int ev = -1;
            if (!this.xmlSource.hasNext()) {
                return ev;
            }
            ev = this.read();
            if (EVENTS) {
                if (ev < 0) {
                    System.out.println("-- Read: end of events");
                } else {
                    System.out.println("-- Event: " + this.strEventType(ev));
                }
            }
            return ev;
        }
        catch (XMLStreamException ex) {
            throw this.handleXMLStreamException(ex);
        }
    }

    private int read() throws XMLStreamException {
        int eventType = this.xmlSource.next();
        if (EVENTS) {
            System.out.println("-- Read: " + this.strEventType(eventType));
        }
        return eventType;
    }

    private boolean startElement() {
        this.processNamespaces();
        boolean hasFrame = this.processBaseAndLang();
        return hasFrame;
    }

    private boolean processBaseAndLang() {
        boolean hasFrame;
        IRIx xmlBase = this.xmlBase();
        String xmlLang = this.xmlLang();
        if (ReaderRDFXML_StAX_SR.TRACE) {
            if (xmlBase != null) {
                this.trace.printf("+ BASE <%s>\n", new Object[]{xmlBase});
            }
            if (xmlLang != null) {
                this.trace.printf("+ LANG @%s\n", new Object[]{xmlLang});
            }
        }
        boolean bl = hasFrame = xmlBase != null || xmlLang != null;
        if (hasFrame) {
            this.pushFrame(xmlBase != null ? xmlBase : this.currentBase, xmlLang != null ? xmlLang : this.currentLang);
        }
        return hasFrame;
    }

    private void endElement(boolean hasFrame) {
        if (hasFrame) {
            this.popFrame();
        }
    }

    private void processNamespaces() {
        if (ReaderRDFXML_StAX_SR.TRACE) {
            int numNS = this.xmlSource.getNamespaceCount();
            for (int i = 0; i < numNS; ++i) {
                String prefix = this.xmlSource.getNamespacePrefix(i);
                String string = this.xmlSource.getNamespaceURI(i);
            }
        }
    }

    private void emitInitialBaseAndNamespaces() {
        String xmlBase = this.attribute(xmlQNameBase);
        if (xmlBase != null) {
            this.emitBase(xmlBase);
        }
        int numNS = this.xmlSource.getNamespaceCount();
        for (int i = 0; i < numNS; ++i) {
            String prefixURI = this.xmlSource.getNamespaceURI(i);
            String prefix = this.xmlSource.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            this.emitPrefix(prefix, prefixURI);
        }
    }

    private void emit(Node subject, Node property, Node object, Location location) {
        Objects.requireNonNull(subject);
        Objects.requireNonNull(property);
        Objects.requireNonNull(object);
        Objects.requireNonNull(location);
        this.destination.triple(Triple.create((Node)subject, (Node)property, (Node)object));
    }

    private void emitReify(Node reify, Node subject, Node property, Node object, Location location) {
        this.emit(subject, property, object, location);
        if (reify != null) {
            this.emit(reify, NodeConst.nodeRDFType, RDF.Nodes.Statement, location);
            this.emit(reify, RDF.Nodes.subject, subject, location);
            this.emit(reify, RDF.Nodes.predicate, property, location);
            this.emit(reify, RDF.Nodes.object, object, location);
        }
    }

    private void emitBase(String base) {
        this.destination.base(base);
    }

    private void emitPrefix(String prefix, String iriStr) {
        this.destination.prefix(prefix, iriStr);
    }

    private IRIx xmlBase() {
        String baseStr = this.attribute(xmlQNameBase);
        if (baseStr == null) {
            return null;
        }
        Location location = this.location();
        IRIx irix = this.resolveIRIxAny(baseStr, location);
        if (irix.isRelative()) {
            this.RDFXMLparseWarning("Relative URI for base: <" + baseStr + ">", location);
        }
        return irix;
    }

    private String xmlLang() {
        return this.attribute(xmlQNameLang);
    }

    private Node iriFromID(String idStr, Location location) {
        this.checkValidNCName(idStr, location);
        Location prev = this.previousUseOfID(idStr, location);
        if (prev != null) {
            this.RDFXMLparseWarning("Reuse of rdf:ID '" + idStr + "' at " + ParserRRX_StAX_SR.str(prev), location);
        }
        Node uri = this.iriResolve("#" + idStr, location);
        return uri;
    }

    private Node iriDirect(String uriStr, Location location) {
        Objects.requireNonNull(uriStr);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createURI(uriStr, (long)line, (long)col);
    }

    private Node iriResolve(String uriStr, Location location) {
        Objects.requireNonNull(uriStr);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return uriStr.startsWith("_:") ? this.parserProfile.createURI(uriStr, (long)line, (long)col) : this.parserProfile.createURI(this.resolveIRIx(uriStr, location), (long)line, (long)col);
    }

    private IRIx resolveIRIx(String uriStr, Location location) {
        try {
            IRIx iri = this.resolveIRIxAny(uriStr, location);
            if (iri.isRelative()) {
                throw this.RDFXMLparseError("Relative URI encountered: <" + iri.str() + ">", location);
            }
            return iri;
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), location);
        }
    }

    private IRIx resolveIRIxAny(String uriStr, Location location) {
        try {
            return (IRIx)this.currentIriCache.get((Object)uriStr, uri -> {
                if (this.currentBase != null) {
                    return this.currentBase.resolve(uri);
                }
                return IRIx.create((String)uriStr);
            });
        }
        catch (IRIException ex) {
            throw this.RDFXMLparseError(ex.getMessage(), location);
        }
    }

    private Node blankNode(Location location) {
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createBlankNode(null, line, col);
    }

    private Node blankNode(String label, Location location) {
        Objects.requireNonNull(label);
        Objects.requireNonNull(location);
        this.checkValidNCName(label, location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createBlankNode(null, label, line, col);
    }

    private Node literal(String lexical, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createStringLiteral(lexical, line, col);
    }

    private Node literal(String lexical, String lang, Location location) {
        if (lang == null) {
            return this.literal(lexical, location);
        }
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createLangLiteral(lexical, lang, line, col);
    }

    private Node literalDatatype(String lexical, String datatype, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        RDFDatatype dt = NodeFactory.getType((String)datatype);
        return this.parserProfile.createTypedLiteral(lexical, dt, line, col);
    }

    private Node literalDatatype(String lexical, RDFDatatype datatype, Location location) {
        Objects.requireNonNull(lexical);
        Objects.requireNonNull(datatype);
        Objects.requireNonNull(location);
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        return this.parserProfile.createTypedLiteral(lexical, datatype, line, col);
    }

    private boolean qNameMatches(QName qName1, QName qName2) {
        return Objects.equals(qName1.getNamespaceURI(), qName2.getNamespaceURI()) && Objects.equals(qName1.getLocalPart(), qName2.getLocalPart());
    }

    private void checkValidNCName(String string, Location location) {
        boolean isValid = XML11Char.isXML11ValidNCName((String)string);
        if (!isValid) {
            this.RDFXMLparseWarning("Not a valid XML NCName: '" + string + "'", location);
        }
    }

    private void noContentAllowed(XMLEvent event) {
        if (event.isCharacters()) {
            String content = event.asCharacters().getData();
            content = ParserRRX_StAX_SR.nonWhitespaceMsg(content);
            throw this.RDFXMLparseError("Expected XML start tag or end tag. Found text content (possible striping error): \"" + content + "\"");
        }
    }

    private static boolean isRDF(QName qName) {
        return rdfNS.equals(qName.getNamespaceURI());
    }

    private static boolean isMemberProperty(QName qName) {
        if (!ParserRRX_StAX_SR.isRDF(qName)) {
            return false;
        }
        return ParserRRX_StAX_SR.isMemberPropertyLocalName(qName.getLocalPart());
    }

    private static boolean isMemberPropertyLocalName(String localName) {
        if (!localName.startsWith("_")) {
            return false;
        }
        String number = localName.substring(1);
        if (number.startsWith("-") || number.startsWith("0")) {
            return false;
        }
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException e2) {
            try {
                BigInteger i = new BigInteger(number);
                return true;
            }
            catch (NumberFormatException ee) {
                return false;
            }
        }
    }

    private boolean isNotRecognizedRDFtype(QName qName) {
        if (!ParserRRX_StAX_SR.isRDF(qName)) {
            return false;
        }
        String ln2 = qName.getLocalPart();
        return !knownRDFTypes.contains(ln2);
    }

    private boolean isNotRecognizedRDFproperty(QName qName) {
        if (!ParserRRX_StAX_SR.isRDF(qName)) {
            return false;
        }
        String ln2 = qName.getLocalPart();
        if (ParserRRX_StAX_SR.isMemberPropertyLocalName(ln2)) {
            return false;
        }
        return !knownRDFProperties.contains(ln2);
    }

    private void incIndent() {
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.incIndent();
        }
    }

    private void decIndent() {
        if (ReaderRDFXML_StAX_SR.TRACE) {
            this.trace.decIndent();
        }
    }

    private static boolean isComment(int eventType) {
        return eventType == 5;
    }

    private boolean isWhitespace(int eventType) {
        if (ParserRRX_StAX_SR.lookingAt(eventType, 4)) {
            String s = this.xmlSource.getText();
            return ParserRRX_StAX_SR.isWhitespace(s);
        }
        return false;
    }

    private static boolean isWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            char ich = ch[i];
            if (Character.isWhitespace(ich)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(CharSequence x) {
        return StringUtils.isWhitespace((CharSequence)x);
    }

    private static String str(Location location) {
        if (location == null) {
            return "[-,-]";
        }
        if (location.getLineNumber() < 0 && location.getColumnNumber() < 0) {
            return "[?,?]";
        }
        if (location.getLineNumber() < 0) {
            return String.format("[-, Col: %d]", location.getColumnNumber());
        }
        if (location.getColumnNumber() < 0) {
            return String.format("[Line: %d, -]", location.getLineNumber());
        }
        return String.format("[Line: %d, Col: %d]", location.getLineNumber(), location.getColumnNumber());
    }

    private static String str(QName qName) {
        String prefix = qName.getPrefix();
        if (prefix == null || prefix.isEmpty()) {
            return String.format("%s", qName.getLocalPart());
        }
        return String.format("%s:%s", qName.getPrefix(), qName.getLocalPart());
    }

    private String strEventType(int eventType) {
        return switch (eventType) {
            case 1 -> ParserRRX_StAX_SR.str(this.xmlSource.getName());
            case 2 -> "/" + ParserRRX_StAX_SR.str(this.xmlSource.getName());
            case 4 -> "Event Characters";
            case 5 -> "Event Comment";
            case 7 -> "Event StartDocument";
            case 8 -> "Event EndDocument";
            case 11 -> "DTD";
            case 15 -> "DTD Entity Decl";
            case 9 -> "DTD Entity Ref";
            default -> "" + eventType;
        };
    }

    private static String nonWhitespaceMsg(String string) {
        int MaxLen = 10;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            int len = Math.min(10, length - i);
            Object x = string.substring(i, i + len);
            if (length > 10) {
                x = (String)x + "...";
            }
            x = EscapeStr.stringEsc((String)x);
            x = ((String)x).stripTrailing();
            return x;
        }
        throw new RDFXMLParseException("Failed to find any non-whitespace characters");
    }

    private record BaseLang(IRIx base, String lang, Cache<String, IRIx> iriCache) {
    }

    private static enum QNameUsage {
        TypedNodeElement("typed node element"),
        PropertyElement("property element");

        final String msg;

        private QNameUsage(String msg) {
            this.msg = msg;
        }
    }

    private static class Counter {
        int value = 1;

        private Counter() {
        }
    }

    static interface Emitter {
        public void emit(Node var1, Node var2, Node var3, Location var4);
    }
}

