/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Set;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.xerces.DatatypeFactoryInst;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NVCompare;
import org.apache.jena.sparql.expr.NVFactory;
import org.apache.jena.sparql.expr.NVOps;
import org.apache.jena.sparql.expr.ValueSpace;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDateTime;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDuration;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLang;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLangDir;
import org.apache.jena.sparql.expr.nodevalue.NodeValueNode;
import org.apache.jena.sparql.expr.nodevalue.NodeValueSortKey;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.XSDNumUtils;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeValue
extends ExprNode {
    static Logger log;
    public static boolean VerboseWarnings;
    public static boolean VerboseExceptions;
    public static DatatypeFactory xmlDatatypeFactory;
    private static int NODEVALUE_CACHE_SIZE;
    private static Cache<Node, NodeValue> nodeValueCache;
    private static Set<RDFDatatype> noCache;
    public static final NodeValue TRUE;
    public static final NodeValue FALSE;
    public static final NodeValue nvEmptyString;
    public static final NodeValue nvZERO;
    public static final NodeValue nvONE;
    public static final NodeValue nvTEN;
    public static final NodeValue nvDecimalZERO;
    public static final NodeValue nvDecimalONE;
    public static final NodeValue nvDoubleNegZERO;
    public static final NodeValue nvDoubleNaN;
    public static final NodeValue nvDoubleINF;
    public static final NodeValue nvDoubleNegINF;
    @Deprecated
    public static final NodeValue nvNegZERO;
    @Deprecated
    public static final NodeValue nvNaN;
    @Deprecated
    public static final NodeValue nvINF;
    @Deprecated
    public static final NodeValue nvNegINF;
    public static final String xsdNamespace = "http://www.w3.org/2001/XMLSchema#";
    private Node node = null;

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        return Set.of();
    }

    public static NodeValue parse(String string) {
        return NodeValue.makeNode(NodeFactoryExtra.parseNode(string));
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(BigInteger.valueOf(i));
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeSortKey(String s, String collation2) {
        return new NodeValueSortKey(s, collation2);
    }

    public static NodeValue makeLangString(String s, String lang) {
        return new NodeValueLang(s, lang);
    }

    public static NodeValue makeDirLangString(String s, String lang, String langDir) {
        return new NodeValueLangDir(s, lang, langDir);
    }

    public static NodeValue makeDirLangString(String s, String lang, TextDirection textDirection) {
        return new NodeValueLangDir(s, lang, textDirection);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(BigDecimal.valueOf(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdate);
    }

    @Deprecated(forRemoval=true)
    public static NodeValue makeDateTime(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString((Calendar)cal);
        return NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDateTime(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
        return new NodeValueDateTime(cal, node);
    }

    @Deprecated(forRemoval=true)
    public static NodeValue makeDate(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateString((Calendar)cal);
        return NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static NodeValue makeDate(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
        return new NodeValueDateTime(cal, node);
    }

    public static NodeValue makeDuration(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDduration);
    }

    public static NodeValue makeDuration(Duration duration) {
        return new NodeValueDuration(duration);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node node) {
        return NodeValue.nodeToNodeValue(node);
    }

    public static NodeValue makeNode(String lexicalForm, RDFDatatype dtype) {
        Node n = NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)dtype);
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            Log.warn(NodeValue.class, (String)("Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')"));
        }
        Node n = null;
        if (langTag != null) {
            n = NodeFactory.createLiteralLang((String)lexicalForm, (String)langTag);
        } else if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)dType);
        } else {
            n = NodeFactory.createLiteralString((String)lexicalForm);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDboolean);
    }

    public static NodeValue makeNodeInteger(long v) {
        return NodeValue.makeNode(Long.toString(v), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static NodeValue makeNodeFloat(float f) {
        return NodeValue.makeNode(XSDNumUtils.stringForm(f), (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static NodeValue makeNodeDouble(double v) {
        return NodeValue.makeNode(XSDNumUtils.stringForm(v), (RDFDatatype)XSDDatatype.XSDdouble);
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        String lex = XSDNumUtils.stringFormatARQ(decimal);
        return NodeValue.makeNode(lex, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeNodeString(String string) {
        return NodeValue.makeNode(string, (RDFDatatype)XSDDatatype.XSDstring);
    }

    public static NodeValue makeNodeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static NodeValue makeNodeDuration(Duration duration, Node node) {
        return new NodeValueDuration(duration, node);
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return this;
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        return this;
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node n = this.asNode();
        n = (Node)transform.apply(n);
        return ExprLib.nodeToExpr(n);
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public NodeValue getConstant() {
        return this;
    }

    public boolean isIRI() {
        this.forceToNode();
        return this.node.isURI();
    }

    public boolean isBlank() {
        this.forceToNode();
        return this.node.isBlank();
    }

    public boolean isTripleTerm() {
        this.forceToNode();
        return this.node.isTripleTerm();
    }

    public ValueSpace getValueSpace() {
        return NodeValue.classifyValueSpace(this);
    }

    public static ValueSpace classifyValueOp(NodeValue nv1, NodeValue nv2) {
        ValueSpace c2;
        ValueSpace c1 = NodeValue.classifyValueSpace(nv1);
        if (c1 == (c2 = NodeValue.classifyValueSpace(nv2))) {
            return c1;
        }
        if (c1 == ValueSpace.VSPACE_UNKNOWN || c2 == ValueSpace.VSPACE_UNKNOWN) {
            return ValueSpace.VSPACE_UNKNOWN;
        }
        return ValueSpace.VSPACE_DIFFERENT;
    }

    static ValueSpace classifyValueSpace(NodeValue nv) {
        return ValueSpace.valueSpace(nv);
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        return NVCompare.sameValueAs(nv1, nv2);
    }

    public static boolean notSameValueAs(Node n1, Node n2) {
        return NodeValue.notSameValueAs(NodeValue.makeNode(n1), NodeValue.makeNode(n2));
    }

    public static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        return NVCompare.notSameValueAs(nv1, nv2);
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        int x = NVCompare.compareByValue(nv1, nv2);
        if (x == 2 || x == -9) {
            throw new ExprNotComparableException(null);
        }
        return x;
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        return NVCompare.compareAlways(nv1, nv2);
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteralDatatypeURI();
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean isLiteral() {
        return this.getNode() == null || this.getNode().isLiteral();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLangString() {
        return false;
    }

    public boolean isSortKey() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean hasDateTime() {
        return this.isDateTime() || this.isDate() || this.isTime() || this.isGYear() || this.isGYearMonth() || this.isGMonth() || this.isGMonthDay() || this.isGDay();
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isTime() {
        return false;
    }

    public boolean isDuration() {
        return false;
    }

    public boolean isYearMonthDuration() {
        return this.isDuration() && NVOps.isYearMonthDuration(this.getDuration());
    }

    public boolean isDayTimeDuration() {
        return this.isDuration() && NVOps.isDayTimeDuration(this.getDuration());
    }

    public boolean isGYear() {
        return false;
    }

    public boolean isGYearMonth() {
        return false;
    }

    public boolean isGMonth() {
        return false;
    }

    public boolean isGMonthDay() {
        return false;
    }

    public boolean isGDay() {
        return false;
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalTypeException("Not a boolean: " + String.valueOf(this)));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalTypeException("Not a string: " + String.valueOf(this)));
        return null;
    }

    public String getLang() {
        NodeValue.raise(new ExprEvalTypeException("Not a lang string: " + String.valueOf(this)));
        return null;
    }

    public String getLangDir() {
        NodeValue.raise(new ExprEvalTypeException("Not a langdir string: " + String.valueOf(this)));
        return null;
    }

    public NodeValueSortKey getSortKey() {
        NodeValue.raise(new ExprEvalTypeException("Not a sort key: " + String.valueOf(this)));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalTypeException("Not an integer: " + String.valueOf(this)));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalTypeException("Not a decimal: " + String.valueOf(this)));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalTypeException("Not a float: " + String.valueOf(this)));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalTypeException("Not a double: " + String.valueOf(this)));
        return Double.NaN;
    }

    public XMLGregorianCalendar getDateTime() {
        NodeValue.raise(new ExprEvalTypeException("No DateTime value: " + String.valueOf(this)));
        return null;
    }

    public Duration getDuration() {
        NodeValue.raise(new ExprEvalTypeException("Not a duration: " + String.valueOf(this)));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        RDFDatatype dt;
        if (node.isLiteral() && noCache.contains(dt = node.getLiteralDatatype())) {
            return NodeValue.nodeToNodeValueMaker(node);
        }
        if (node.isExt()) {
            return new NodeValueNode(node);
        }
        NodeValue nv = (NodeValue)nodeValueCache.get((Object)node, NodeValue::nodeToNodeValueMaker);
        return nv;
    }

    private static NodeValue nodeToNodeValueMaker(Node node) {
        if (!node.isConcrete()) {
            if (node.isVariable()) {
                throw new ExprException("Variable passed to NodeValue.nodeToNodeValue: " + String.valueOf(node));
            }
            if (node.isTripleTerm()) {
                throw new ExprException("Triple term with a variable passed to NodeValue.nodeToNodeValue: " + String.valueOf(node));
            }
            throw new ExprException("Node is not a constant");
        }
        NodeValue nv = NVFactory.create(node);
        return nv;
    }

    public static void raise(ExprException ex) {
        throw ex;
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + String.valueOf(this)));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(new SerializationContext());
    }

    public final String asQuotedString(SerializationContext context2) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context2);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    @Override
    public int hashCode() {
        return this.asNode().hashCode();
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        return this.asNode().equals((Object)nv.asNode());
    }

    public abstract void visit(NodeValueVisitor var1);

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    @Override
    public String toString() {
        return this.asQuotedString();
    }

    static {
        JenaSystem.init();
        log = LoggerFactory.getLogger(NodeValue.class);
        VerboseWarnings = true;
        VerboseExceptions = false;
        xmlDatatypeFactory = DatatypeFactoryInst.newDatatypeFactory();
        NODEVALUE_CACHE_SIZE = 10000;
        nodeValueCache = CacheFactory.createCache((int)NODEVALUE_CACHE_SIZE);
        noCache = Set.of(CompositeDatatypeList.datatype(), CompositeDatatypeMap.datatype());
        TRUE = NodeValue.makeNode("true", (RDFDatatype)XSDDatatype.XSDboolean);
        FALSE = NodeValue.makeNode("false", (RDFDatatype)XSDDatatype.XSDboolean);
        nvEmptyString = NodeValue.makeString("");
        nvZERO = NodeValue.makeNode(NodeConst.nodeZero);
        nvONE = NodeValue.makeNode(NodeConst.nodeOne);
        nvTEN = NodeValue.makeNode(NodeConst.nodeTen);
        nvDecimalZERO = NodeValue.makeNode("0.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        nvDecimalONE = NodeValue.makeNode("1.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        nvDoubleNegZERO = NodeValue.makeNode("-0.0e0", (RDFDatatype)XSDDatatype.XSDdouble);
        nvDoubleNaN = NodeValue.makeNode("NaN", (RDFDatatype)XSDDatatype.XSDdouble);
        nvDoubleINF = NodeValue.makeNode("INF", (RDFDatatype)XSDDatatype.XSDdouble);
        nvDoubleNegINF = NodeValue.makeNode("-INF", (RDFDatatype)XSDDatatype.XSDdouble);
        nvNegZERO = nvDoubleNegZERO;
        nvNaN = nvDoubleNaN;
        nvINF = nvDoubleINF;
        nvNegINF = nvDoubleNegINF;
    }
}

