/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueDateTime
extends NodeValue {
    private final XMLGregorianCalendar datetime;

    public NodeValueDateTime(XMLGregorianCalendar datetime, Node n) {
        super(n);
        this.datetime = datetime;
    }

    @Override
    public boolean isDateTime() {
        RDFDatatype dt = this.getNode().getLiteralDatatype();
        return XSDDatatype.XSDdateTime.equals((Object)dt) || XSDDatatype.XSDdateTimeStamp.equals((Object)dt);
    }

    @Override
    public boolean isDate() {
        return XSDDatatype.XSDdate.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isTime() {
        return XSDDatatype.XSDtime.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYear() {
        return XSDDatatype.XSDgYear.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYearMonth() {
        return XSDDatatype.XSDgYearMonth.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonth() {
        return XSDDatatype.XSDgMonth.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonthDay() {
        return XSDDatatype.XSDgMonthDay.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGDay() {
        return XSDDatatype.XSDgDay.equals((Object)this.getNode().getLiteralDatatype());
    }

    @Override
    public XMLGregorianCalendar getDateTime() {
        return (XMLGregorianCalendar)this.datetime.clone();
    }

    @Override
    protected Node makeNode() {
        return null;
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

