/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.urifunctions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.urifunctions.SPARQLEvalException;
import org.apache.jena.sparql.expr.urifunctions.SPARQLFuncOp;

public class SPARQLDispatch {
    static final String NS0 = "http://www.w3.org/ns/sparql#".substring(0, "http://www.w3.org/ns/sparql#".length() - 1);

    public static NodeValue exec(String uri, List<NodeValue> args) {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(args);
        NodeValue[] a = (NodeValue[])args.toArray(NodeValue[]::new);
        return SPARQLDispatch.exec(uri, a);
    }

    public static NodeValue exec(String uri, NodeValue ... args) {
        Call call;
        if (((String)uri).startsWith("#")) {
            uri = NS0 + (String)uri;
        }
        if ((call = SPARQLDispatch.getDispatchMap().get(uri)) == null) {
            throw new SPARQLEvalException("No such function: " + (String)uri);
        }
        return call.exec(args);
    }

    private static RuntimeException exception(String format, Object ... args) {
        String msg = String.format(format, args);
        return new SPARQLEvalException(msg);
    }

    static void register(Map<String, Call> map, String uri, Function0 function) {
        Call call = args -> {
            if (args.length != 0) {
                throw SPARQLDispatch.exception("%s: Expected zero arguments. Got %d", uri, args.length);
            }
            return function.exec();
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function1 function) {
        Call call = args -> {
            if (args.length != 1) {
                throw SPARQLDispatch.exception("%s: Expected one argument. Got %d", uri, args.length);
            }
            return function.exec(args[0]);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function2 function) {
        Call call = args -> {
            if (args.length != 2) {
                throw SPARQLDispatch.exception("%s: Expected two arguments. Got %d", uri, args.length);
            }
            return function.exec(args[0], args[1]);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function3 function) {
        Call call = args -> {
            if (args.length != 3) {
                throw SPARQLDispatch.exception("%s: Expected three arguments. Got %d", uri, args.length);
            }
            return function.exec(args[0], args[1], args[2]);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function4 function) {
        Call call = args -> {
            if (args.length != 3) {
                throw SPARQLDispatch.exception("%s: Expected  arguments. Got %d", uri, args.length);
            }
            return function.exec(args[0], args[1], args[2], args[3]);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function1 function1, Function2 function2) {
        Call call = args -> {
            if (args.length == 1) {
                return function1.exec(args[0]);
            }
            if (args.length == 2) {
                return function2.exec(args[0], args[1]);
            }
            throw SPARQLDispatch.exception("%s: Expected one or two arguments. Got %d", uri, args.length);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function2 function2, Function3 function3) {
        Call call = args -> {
            if (args.length == 2) {
                return function2.exec(args[0], args[1]);
            }
            if (args.length == 3) {
                return function3.exec(args[0], args[1], args[2]);
            }
            throw SPARQLDispatch.exception("%s: Expected two or three arguments. Got %d", uri, args.length);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, Function3 function3, Function4 function4) {
        Call call = args -> {
            if (args.length == 3) {
                return function3.exec(args[0], args[1], args[2]);
            }
            if (args.length == 4) {
                return function4.exec(args[0], args[1], args[2], args[3]);
            }
            throw SPARQLDispatch.exception("%s: Expected three or four arguments. Got %d", uri, args.length);
        };
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void register(Map<String, Call> map, String uri, FunctionN function) {
        Call call = args -> function.exec(args);
        SPARQLDispatch.registerCall(map, uri, call);
    }

    static void registerCall(Map<String, Call> map, String localName, Call call) {
        String uri = "http://www.w3.org/ns/sparql#" + localName;
        Call oldCall = map.put(uri, call);
        if (oldCall != null) {
            throw new InternalErrorException("Multiple registration of " + uri);
        }
    }

    static Map<String, Call> getDispatchMap() {
        return LazyDispatchMap.dispatchMap();
    }

    static Map<String, Call> buildDispatchMap() {
        HashMap<String, Call> map = new HashMap<String, Call>();
        SPARQLDispatch.register(map, "plus", SPARQLFuncOp::sparql_add);
        SPARQLDispatch.register(map, "add", SPARQLFuncOp::sparql_add);
        SPARQLDispatch.register(map, "subtract", SPARQLFuncOp::sparql_subtract);
        SPARQLDispatch.register(map, "minus", SPARQLFuncOp::sparql_subtract);
        SPARQLDispatch.register(map, "multiply", SPARQLFuncOp::sparql_multiply);
        SPARQLDispatch.register(map, "divide", SPARQLFuncOp::sparql_divide);
        SPARQLDispatch.register(map, "equals", SPARQLFuncOp::sparql_equals);
        SPARQLDispatch.register(map, "not-equals", SPARQLFuncOp::sparql_not_equals);
        SPARQLDispatch.register(map, "greaterThan", SPARQLFuncOp::sparql_greaterThan);
        SPARQLDispatch.register(map, "greaterThanOrEqual", SPARQLFuncOp::sparql_greaterThanOrEqual);
        SPARQLDispatch.register(map, "lessThan", SPARQLFuncOp::sparql_lessThan);
        SPARQLDispatch.register(map, "lessThanOrEqual", SPARQLFuncOp::sparql_lessThanOrEqual);
        SPARQLDispatch.register(map, "and", SPARQLFuncOp::sparql_function_and);
        SPARQLDispatch.register(map, "or", SPARQLFuncOp::sparql_function_or);
        SPARQLDispatch.register(map, "not", SPARQLFuncOp::sparql_function_not);
        SPARQLDispatch.register(map, "unary-minus", SPARQLFuncOp::sparql_unary_minus);
        SPARQLDispatch.register(map, "unary-plus", SPARQLFuncOp::sparql_unary_plus);
        SPARQLDispatch.register(map, "abs", SPARQLFuncOp::sparql_abs);
        SPARQLDispatch.register(map, "bnode", SPARQLFuncOp::sparql_bnode);
        SPARQLDispatch.register(map, "ceil", SPARQLFuncOp::sparql_ceil);
        SPARQLDispatch.register(map, "concat", (NodeValue[] args) -> SPARQLFuncOp.sparql_concat(args));
        SPARQLDispatch.register(map, "contains", SPARQLFuncOp::sparql_contains);
        SPARQLDispatch.register(map, "datatype", SPARQLFuncOp::sparql_datatype);
        SPARQLDispatch.register(map, "encode", SPARQLFuncOp::sparql_encode);
        SPARQLDispatch.register(map, "floor", SPARQLFuncOp::sparql_floor);
        SPARQLDispatch.register(map, "haslang", SPARQLFuncOp::sparql_haslang);
        SPARQLDispatch.register(map, "haslangdir", SPARQLFuncOp::sparql_haslangdir);
        SPARQLDispatch.register(map, "iri", SPARQLFuncOp::sparql_iri, SPARQLFuncOp::arq_iri);
        SPARQLDispatch.register(map, "uri", SPARQLFuncOp::sparql_uri, SPARQLFuncOp::arq_uri);
        SPARQLDispatch.register(map, "isBlank", SPARQLFuncOp::sparql_isBlank);
        SPARQLDispatch.register(map, "isLiteral", SPARQLFuncOp::sparql_isLiteral);
        SPARQLDispatch.register(map, "isNumeric", SPARQLFuncOp::sparql_isNumeric);
        SPARQLDispatch.register(map, "isIRI", SPARQLFuncOp::sparql_isIRI);
        SPARQLDispatch.register(map, "isURI", SPARQLFuncOp::sparql_isURI);
        SPARQLDispatch.register(map, "lang", SPARQLFuncOp::sparql_lang);
        SPARQLDispatch.register(map, "langMatches", SPARQLFuncOp::sparql_langMatches);
        SPARQLDispatch.register(map, "langdir", SPARQLFuncOp::sparql_langdir);
        SPARQLDispatch.register(map, "lcase", SPARQLFuncOp::sparql_lcase);
        SPARQLDispatch.register(map, "ucase", SPARQLFuncOp::sparql_ucase);
        SPARQLDispatch.register(map, "now", SPARQLFuncOp::sparql_now);
        SPARQLDispatch.register(map, "rand", SPARQLFuncOp::sparql_rand);
        SPARQLDispatch.register(map, "regex", SPARQLFuncOp::sparql_regex, SPARQLFuncOp::sparql_regex);
        SPARQLDispatch.register(map, "replace", SPARQLFuncOp::sparql_replace, SPARQLFuncOp::sparql_replace);
        SPARQLDispatch.register(map, "round", SPARQLFuncOp::sparql_round);
        SPARQLDispatch.register(map, "sameTerm", SPARQLFuncOp::sparql_sameTerm);
        SPARQLDispatch.register(map, "sameValue", SPARQLFuncOp::sparql_sameValue);
        SPARQLDispatch.register(map, "uuid", SPARQLFuncOp::sparql_uuid);
        SPARQLDispatch.register(map, "year", SPARQLFuncOp::sparql_year);
        SPARQLDispatch.register(map, "month", SPARQLFuncOp::sparql_month);
        SPARQLDispatch.register(map, "day", SPARQLFuncOp::sparql_day);
        SPARQLDispatch.register(map, "hours", SPARQLFuncOp::sparql_hours);
        SPARQLDispatch.register(map, "minutes", SPARQLFuncOp::sparql_minutes);
        SPARQLDispatch.register(map, "seconds", SPARQLFuncOp::sparql_seconds);
        SPARQLDispatch.register(map, "tz", SPARQLFuncOp::sparql_tz);
        SPARQLDispatch.register(map, "timezone", SPARQLFuncOp::sparql_timezone);
        SPARQLDispatch.register(map, "subject", SPARQLFuncOp::sparql_subject);
        SPARQLDispatch.register(map, "object", SPARQLFuncOp::sparql_object);
        SPARQLDispatch.register(map, "predicate", SPARQLFuncOp::sparql_predicate);
        SPARQLDispatch.register(map, "isTriple", SPARQLFuncOp::sparql_isTriple);
        SPARQLDispatch.register(map, "triple", SPARQLFuncOp::sparql_triple);
        SPARQLDispatch.register(map, "md5", SPARQLFuncOp::sparql_md5);
        SPARQLDispatch.register(map, "sha1", SPARQLFuncOp::sparql_sha1);
        SPARQLDispatch.register(map, "sha224", SPARQLFuncOp::sparql_sha224);
        SPARQLDispatch.register(map, "sha256", SPARQLFuncOp::sparql_sha256);
        SPARQLDispatch.register(map, "sha384", SPARQLFuncOp::sparql_sha384);
        SPARQLDispatch.register(map, "sha512", SPARQLFuncOp::sparql_sha512);
        SPARQLDispatch.register(map, "str", SPARQLFuncOp::sparql_str);
        SPARQLDispatch.register(map, "strafter", SPARQLFuncOp::sparql_strafter);
        SPARQLDispatch.register(map, "strbefore", SPARQLFuncOp::sparql_strbefore);
        SPARQLDispatch.register(map, "strdt", SPARQLFuncOp::sparql_strdt);
        SPARQLDispatch.register(map, "strends", SPARQLFuncOp::sparql_strends);
        SPARQLDispatch.register(map, "strlang", SPARQLFuncOp::sparql_strlang);
        SPARQLDispatch.register(map, "strlangdir", SPARQLFuncOp::sparql_strlangdir);
        SPARQLDispatch.register(map, "strlen", SPARQLFuncOp::sparql_strlen);
        SPARQLDispatch.register(map, "strstarts", SPARQLFuncOp::sparql_strstarts);
        SPARQLDispatch.register(map, "substr", SPARQLFuncOp::sparql_substr, SPARQLFuncOp::sparql_substr);
        SPARQLDispatch.register(map, "struuid", SPARQLFuncOp::sparql_struuid);
        return Map.copyOf(map);
    }

    static interface Call {
        public NodeValue exec(NodeValue ... var1);
    }

    static interface Function0 {
        public NodeValue exec();
    }

    static interface Function1 {
        public NodeValue exec(NodeValue var1);
    }

    static interface Function2 {
        public NodeValue exec(NodeValue var1, NodeValue var2);
    }

    static interface Function3 {
        public NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3);
    }

    static interface Function4 {
        public NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3, NodeValue var4);
    }

    static interface FunctionN {
        public NodeValue exec(NodeValue ... var1);
    }

    private static class LazyDispatchMap {
        private static final Map<String, Call> INITIALIZED_MAP = SPARQLDispatch.buildDispatchMap();

        private LazyDispatchMap() {
        }

        private static Map<String, Call> dispatchMap() {
            return INITIALIZED_MAP;
        }
    }
}

