/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.procedure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.procedure.ProcedureFactory;
import org.apache.jena.sparql.procedure.ProcedureFactoryAuto;
import org.apache.jena.sparql.procedure.StandardProcedures;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappedLoader;

public class ProcedureRegistry {
    Map<String, ProcedureFactory> registry = new HashMap<String, ProcedureFactory>();
    Set<String> attemptedLoads = new HashSet<String>();

    public static synchronized ProcedureRegistry standardRegistry() {
        ProcedureRegistry reg = new ProcedureRegistry();
        StandardProcedures.loadStdDefs(reg);
        return reg;
    }

    public static synchronized ProcedureRegistry get() {
        ProcedureRegistry reg = ProcedureRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = ProcedureRegistry.standardRegistry();
            ProcedureRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public static ProcedureRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (ProcedureRegistry)context2.get(ARQConstants.registryProcedures);
    }

    public static void set(Context context2, ProcedureRegistry reg) {
        context2.set(ARQConstants.registryProcedures, reg);
    }

    public void put(String uri, ProcedureFactory f) {
        this.registry.put(uri, f);
    }

    public void put(String uri, Class<?> procClass) {
        if (!Procedure.class.isAssignableFrom(procClass)) {
            Log.warn((Object)this, (String)("Class " + procClass.getName() + " is not a Procedure"));
            return;
        }
        this.registry.put(uri, new ProcedureFactoryAuto(procClass));
    }

    public ProcedureFactory get(String uri) {
        ProcedureFactory procedure = this.registry.get(uri);
        if (procedure != null) {
            return procedure;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> procedureClass = MappedLoader.loadClass(uri, Procedure.class);
        if (procedureClass == null) {
            return null;
        }
        this.put(uri, procedureClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public ProcedureFactory remove(String uri) {
        return this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }
}

