/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.InputStream;
import java.util.Objects;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.rowset.RowSetReaderRegistry;
import org.apache.jena.riot.system.streammgr.StreamManager;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;

public class ResultsReader {
    private final Lang hintLang;
    private final Lang forceLang;
    private final Context context;

    public static Builder create() {
        return new Builder();
    }

    private ResultsReader(Lang hintLang, Lang forceLang, Context context2) {
        this.hintLang = hintLang;
        this.forceLang = forceLang;
        this.context = context2;
    }

    private Lang determinLang(TypedInputStream in, String url) {
        if (in == null) {
            throw new RiotNotFoundException(url);
        }
        Lang lang = this.forceLang;
        if (lang == null) {
            ContentType ct = WebContent.determineCT(in.getContentType(), this.hintLang, url);
            lang = RDFLanguages.contentTypeToLang(ct);
        }
        if (lang == null) {
            throw new RiotException("Can't identify the result set syntax from " + url);
        }
        return lang;
    }

    public ResultSet read(String urlOrFilename) {
        Objects.nonNull(urlOrFilename);
        try (TypedInputStream in = StreamManager.get(this.context).open(urlOrFilename);){
            Lang lang = this.determinLang(in, urlOrFilename);
            ResultSet resultSet = this.readResults(in, lang).getResultSet();
            return resultSet;
        }
    }

    public ResultSet read(InputStream input) {
        Lang lang;
        Objects.nonNull(input);
        Lang lang2 = lang = this.forceLang != null ? this.forceLang : this.hintLang;
        if (lang == null) {
            throw new RiotException("Need a syntax to read a result set from an InputStream");
        }
        return this.readResults(input, lang).getResultSet();
    }

    public RowSet readRowSet(String urlOrFilename) {
        Objects.nonNull(urlOrFilename);
        try (TypedInputStream in = StreamManager.get(this.context).open(urlOrFilename);){
            Lang lang = this.determinLang(in, urlOrFilename);
            RowSet rowSet = this.readAny(in.getInputStream(), lang).rowSet();
            return rowSet;
        }
    }

    public RowSet readRowSet(InputStream input) {
        Lang lang;
        Objects.nonNull(input);
        Lang lang2 = lang = this.forceLang != null ? this.forceLang : this.hintLang;
        if (lang == null) {
            throw new RiotException("Need a syntax to read a result set from an InputStream");
        }
        return this.readAny(input, lang).rowSet();
    }

    public SPARQLResult readAny(String urlOrFilename) {
        Objects.nonNull(urlOrFilename);
        try (TypedInputStream in = StreamManager.get(this.context).open(urlOrFilename);){
            Lang lang = this.determinLang(in, urlOrFilename);
            SPARQLResult sPARQLResult = this.readResults(in.getInputStream(), lang);
            return sPARQLResult;
        }
    }

    public SPARQLResult readAny(InputStream input) {
        Lang lang;
        Objects.nonNull(input);
        Lang lang2 = lang = this.forceLang != null ? this.forceLang : this.hintLang;
        if (lang == null) {
            throw new RiotException("Need a syntax to read a result set from an InputStream");
        }
        return this.readResults(input, lang);
    }

    private SPARQLResult readResults(InputStream input, Lang lang) {
        return SPARQLResult.adapt(this.readAny(input, lang));
    }

    private QueryExecResult readAny(InputStream input, Lang lang) {
        if (!RowSetReaderRegistry.isRegistered(lang)) {
            throw new RiotException("Not registered as a SPARQL result set input syntax: " + String.valueOf(lang));
        }
        RowSetReaderFactory factory = RowSetReaderRegistry.getFactory(lang);
        if (factory == null) {
            throw new RiotException("No ResultSetReaderFactory for " + String.valueOf(lang));
        }
        RowSetReader reader = factory.create(lang);
        QueryExecResult result = reader.readAny(input, this.context);
        return result;
    }

    static {
        JenaSystem.init();
    }

    public static class Builder {
        private Lang hintLang = null;
        private Lang forceLang = null;
        private Context context = null;

        public Builder lang(Lang hintLang) {
            this.hintLang = hintLang;
            return this;
        }

        public Builder forceLang(Lang forceLang) {
            this.forceLang = forceLang;
            return this;
        }

        public Builder context(Context context2) {
            if (context2 == null) {
                return this;
            }
            this.ensureContext();
            this.context.putAll(context2);
            return this;
        }

        private void ensureContext() {
            if (this.context == null) {
                this.context = new Context();
            }
        }

        public ResultsReader build() {
            return new ResultsReader(this.hintLang, this.forceLang, this.context);
        }

        public ResultSet read(String url) {
            return this.build().read(url);
        }

        public ResultSet read(InputStream input) {
            return this.build().read(input);
        }

        public RowSet readRowSet(String url) {
            return this.build().readRowSet(url);
        }

        public RowSet readRowSet(InputStream input) {
            return this.build().readRowSet(input);
        }
    }
}

