/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryScopeException;

public class QuerySyntaxSubstituteScope {
    public static void scopeCheck(Query query, Collection<Var> vars) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(vars);
        if (vars.isEmpty()) {
            return;
        }
        QuerySyntaxSubstituteScope.checkLevel(query, vars);
        if (query.getQueryPattern() != null) {
            QuerySyntaxSubstituteScope.checkPattern(query.getQueryPattern(), vars);
        }
    }

    public static void checkPattern(Element element, Collection<Var> vars) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(vars);
        SubstituteScopeVisitor visitor = new SubstituteScopeVisitor(vars);
        ElementWalker.walk(element, visitor);
    }

    private static void checkLevel(Query query, Collection<Var> vars) {
        QuerySyntaxSubstituteScope.checkAssignments("Query project expression", vars, query.getProject());
        QuerySyntaxSubstituteScope.checkAssignments("GROUP BY ", vars, query.getGroupBy());
        query.getAggregators().forEach(agg -> QuerySyntaxSubstituteScope.checkAssignment("Aggregator", vars, agg.getVar()));
    }

    private static void checkAssignments(String context2, Collection<Var> vars, VarExprList varExprList) {
        varExprList.forEachVarExpr((v, e2) -> {
            if (e2 != null) {
                QuerySyntaxSubstituteScope.checkAssignment(context2, vars, v);
            }
        });
    }

    private static void checkAssignment(String context2, Collection<Var> vars, Var assignedVar) {
        if (vars.contains((Object)assignedVar)) {
            QuerySyntaxSubstituteScope.reject(context2, assignedVar);
        }
    }

    private static void reject(String elementName, Var badVar) {
        throw new QueryScopeException("Can not use " + String.valueOf((Object)badVar) + " in this query");
    }

    private static class SubstituteScopeVisitor
    extends ElementVisitorBase {
        private Collection<Var> vars;

        SubstituteScopeVisitor(Collection<Var> vars) {
            this.vars = vars;
        }

        @Override
        public void visit(ElementAssign el) {
            Var assignedVar = el.getVar();
            QuerySyntaxSubstituteScope.checkAssignment("LET", this.vars, assignedVar);
        }

        @Override
        public void visit(ElementBind el) {
            Var assignedVar = el.getVar();
            QuerySyntaxSubstituteScope.checkAssignment("BIND", this.vars, assignedVar);
        }

        @Override
        public void visit(ElementData el) {
            List<Var> assignedVars = el.getVars();
            assignedVars.forEach(v -> QuerySyntaxSubstituteScope.checkAssignment("VALUES", this.vars, v));
        }

        @Override
        public void visit(ElementSubQuery el) {
            el.getQuery().getQueryPattern().visit(this);
        }
    }
}

