/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.net.URI;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class License
extends OpenApiElement {
    private String name;
    private URI url;

    public License() {
    }

    public License(License copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.url = copyFrom.url;
    }

    public License copy() {
        return new License(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "url" -> ConverterUtils.toType(this.getUrl(), type);
            default -> super.get(property, type);
        };
    }

    public String getName() {
        return this.name;
    }

    public URI getUrl() {
        return this.url;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.name), "name").addIf(Utils.nn(this.url), "url").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public License set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "name" -> this.setName(Utils.s(value));
            case "url" -> this.setUrl(StringUtils.toUri(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public License setName(String value) {
        this.name = value;
        return this;
    }

    public License setUrl(URI value) {
        this.url = value;
        return this;
    }

    @Override
    public License strict() {
        super.strict();
        return this;
    }

    @Override
    public License strict(Object value) {
        super.strict(value);
        return this;
    }
}

