/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.jpms;

import aQute.bnd.build.model.EE;
import aQute.bnd.classfile.builder.ModuleInfoBuilder;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.verifier.VerifierPlugin;
import aQute.bnd.stream.MapStream;
import aQute.lib.io.ByteBufferDataOutput;
import aQute.lib.strings.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPMSModuleInfoPlugin
implements VerifierPlugin {
    private static final Logger logger = LoggerFactory.getLogger(JPMSModuleInfoPlugin.class);
    private static final Pattern mangledModuleName = Pattern.compile("(.*)-\\d.*");
    private static final EE DEFAULT_MODULE_EE = EE.JavaSE_11;
    private static final String INTERNAL_MODULE_DIRECTIVE = "-internal-module:";

    @Override
    public void verify(Analyzer analyzer) throws Exception {
        Parameters moduleParameters;
        String moduleProperty = analyzer.getProperty("-jpms-module-info");
        if (moduleProperty == null) {
            return;
        }
        Parameters provideCapabilities = new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("Provide-Capability"));
        Parameters requireCapabilities = new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("Require-Capability"));
        if (moduleProperty.isEmpty()) {
            String name = this.name(analyzer);
            int access = Access.OPEN.getValue();
            String version = analyzer.getVersion();
            moduleProperty = String.format("%s;access=%s;version=%s", name, access, version);
        }
        if ((moduleParameters = OSGiHeader.parseHeader(moduleProperty)).isEmpty()) {
            return;
        }
        if (moduleParameters.size() > 1) {
            throw new IllegalArgumentException("Only one -module instruction is allowed:" + moduleParameters);
        }
        Map.Entry<String, Attrs> moduleInstructions = moduleParameters.stream().findFirst().get();
        Parameters moduleInfoOptions = OSGiHeader.parseHeader(analyzer.getProperty("-jpms-module-info-options"));
        Packages contained = analyzer.getContained();
        Packages referred = analyzer.getReferred();
        Packages imports = analyzer.getImports();
        Packages exports = analyzer.getExports();
        Packages index = new Packages();
        for (Jar jar : analyzer.getClasspath()) {
            String moduleName = this.getModuleName(analyzer, jar, moduleInfoOptions);
            String moduleVersion = jar.getModuleVersion();
            Attrs attrs = new Attrs();
            if (moduleName != null) {
                attrs.put(INTERNAL_MODULE_DIRECTIVE, moduleName);
            }
            if (moduleVersion != null) {
                attrs.put("-internal-module-version:", moduleVersion);
            }
            MapStream.of(jar.getDirectories()).filter((path, resources) -> resources != null && !resources.isEmpty() && !path.isEmpty()).map((k, v) -> MapStream.entry(analyzer.getPackageRef((String)k), imports.get(analyzer.getPackageRef((String)k)))).filterKey(Descriptors.PackageRef::isValidPackageName).forEach((packageRef, packageAttrs) -> index.put((Descriptors.PackageRef)packageRef, new Attrs((Attrs)packageAttrs, attrs)));
        }
        Set<Descriptors.PackageRef> bcpEntries = analyzer.getBundleClassPathTypes().keySet().stream().map(Descriptors.TypeRef::getPackageRef).collect(Collectors.toSet());
        ModuleInfoBuilder builder = this.nameAccessAndVersion(moduleInstructions, requireCapabilities, analyzer);
        this.packages(builder, analyzer);
        this.requires(builder, analyzer, moduleInstructions, index, moduleInfoOptions, bcpEntries);
        this.exportPackages(builder, analyzer, exports, bcpEntries);
        this.openPackages(builder, contained);
        this.serviceLoaderProviders(builder, analyzer, provideCapabilities, bcpEntries);
        this.serviceLoaderUses(builder, analyzer, requireCapabilities, bcpEntries);
        this.mainClass(builder, analyzer);
        ByteBufferDataOutput bbout = new ByteBufferDataOutput();
        builder.build().write(bbout);
        analyzer.getJar().putResource("module-info.class", new EmbeddedResource(bbout.toByteBuffer(), analyzer.lastModified()));
    }

    private String getModuleName(Analyzer analyzer, Jar jar, Parameters moduleInfoOptions) throws Exception {
        String moduleName = jar.getModuleName();
        if (moduleName == null) {
            if (jar.getSource() != null && jar.getSource().isDirectory()) {
                return null;
            }
            moduleName = jar.getName();
            Matcher matcher = mangledModuleName.matcher(moduleName);
            if (matcher.matches()) {
                moduleName = matcher.group(1);
            }
            String name = moduleName;
            moduleName = moduleInfoOptions.stream().filterValue(attrs -> name.equals(attrs.get("substitute"))).keys().findFirst().orElse(moduleName);
            if (logger.isDebugEnabled()) {
                logger.debug("Using module name '{}' for: {}", (Object)moduleName, (Object)jar);
            }
        }
        return moduleName;
    }

    private String name(Analyzer analyzer) {
        return analyzer.getProperty("Automatic-Module-Name", analyzer.getBsn());
    }

    private void packages(ModuleInfoBuilder builder, Analyzer analyzer) {
        MapStream.ofNullable(analyzer.getJar().getDirectories()).filterKey(k -> !k.startsWith("META-INF") && !k.startsWith("OSGI-INF") && !k.startsWith("WEB-INF") && !k.isEmpty()).filterValue(Objects::nonNull).filterValue(m -> !m.values().isEmpty()).keys().forEach(builder::packages);
    }

    private void exportPackages(ModuleInfoBuilder builder, Analyzer analyzer, Packages contained, Set<Descriptors.PackageRef> bcpEntries) {
        MapStream.of(analyzer.getExports()).filterKey(k -> !bcpEntries.contains(k)).forEach((packageRef, attrs) -> {
            Set<String> targets = Collections.emptySet();
            Attrs containedAttrs = contained.get((Descriptors.PackageRef)packageRef);
            if (containedAttrs != null && containedAttrs.containsKey("-internal-export-to-modules:")) {
                targets = Strings.splitAsStream(containedAttrs.get("-internal-export-to-modules:")).collect(Collectors.toCollection(JPMSModuleInfoPlugin.setFactory()));
            }
            builder.exports(packageRef.getBinary(), 0, targets);
        });
    }

    private void mainClass(ModuleInfoBuilder builder, Analyzer analyzer) {
        String mainClass = analyzer.getProperty("Main-Class");
        if (mainClass != null) {
            Descriptors.TypeRef typeRef = analyzer.getTypeRefFromFQN(mainClass);
            builder.mainClass(typeRef.getBinary());
        }
    }

    private ModuleInfoBuilder nameAccessAndVersion(Map.Entry<String, Attrs> instruction, Parameters requireCapability, Analyzer analyzer) {
        Attrs attrs = instruction.getValue();
        String name = instruction.getKey();
        String access = attrs.computeIfAbsent("access", k -> Access.OPEN.name());
        String version = attrs.computeIfAbsent("version", k -> analyzer.getVersion());
        ModuleInfoBuilder builder = new ModuleInfoBuilder().module_name(name).module_version(version).module_flags(Access.parse(access).stream().mapToInt(Access::getValue).reduce(0, (l, r) -> l | r));
        return builder;
    }

    private void openPackages(ModuleInfoBuilder builder, Packages contained) {
        contained.stream().filterValue(attrs -> attrs.containsKey("-internal-open-to-modules:")).forEachOrdered((packageRef, attrs) -> {
            Set<String> targets = Strings.splitAsStream(attrs.get("-internal-open-to-modules:")).collect(Collectors.toCollection(JPMSModuleInfoPlugin.setFactory()));
            builder.opens(packageRef.getBinary(), 0, targets);
        });
    }

    private void requires(ModuleInfoBuilder builder, Analyzer analyzer, Map.Entry<String, Attrs> instruction, Packages index, Parameters moduleInfoOptions, Set<Descriptors.PackageRef> bcpEntries) throws Exception {
        String eeAttribute = instruction.getValue().get("ee");
        EE moduleEE = eeAttribute != null ? Optional.of(eeAttribute).map(EE::parse).map(ee -> {
            if (ee.compareTo(EE.JavaSE_9) < 0) {
                if (logger.isWarnEnabled()) {
                    logger.warn("The specified EE " + (Object)ee + " is less than the minimum for JPMS. Reseting to a reasonable default: " + (Object)((Object)DEFAULT_MODULE_EE));
                }
                return DEFAULT_MODULE_EE;
            }
            return ee;
        }).orElseThrow(() -> new IllegalArgumentException("unrecognize ee name: " + eeAttribute)) : DEFAULT_MODULE_EE;
        Packages exports = analyzer.getExports();
        Packages imports = analyzer.getImports();
        Packages referred = analyzer.getReferred();
        Instructions dynamicImportPackages = new Instructions(new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("DynamicImport-Package")));
        Packages externallyReferred = new Packages(referred);
        exports.keySet().forEach(externallyReferred::remove);
        Map requiresMap = externallyReferred.stream().filterKey(packageRef -> {
            if (bcpEntries.contains(packageRef)) {
                return false;
            }
            Attrs attrs = index.get((Descriptors.PackageRef)packageRef);
            Attrs importAttrs = imports.get((Descriptors.PackageRef)packageRef);
            if (attrs == null || !attrs.containsKey(INTERNAL_MODULE_DIRECTIVE)) {
                String eeModuleName = moduleEE.getModules().stream().filterValue(a -> a.getTyped(Attrs.LIST_STRING, "exports").contains(packageRef.getFQN())).keys().findAny().orElse(null);
                if (eeModuleName == null) {
                    if (logger.isDebugEnabled() && MapStream.ofNullable(importAttrs).noneMatch((k, v) -> k.equals("resolution:") && v.equals("optional"))) {
                        logger.debug("Can't find a module name for imported package: {}", (Object)packageRef.getFQN());
                    }
                    return false;
                }
                attrs = attrs != null ? attrs : (importAttrs != null ? new Attrs(importAttrs) : new Attrs());
                attrs.put(INTERNAL_MODULE_DIRECTIVE, eeModuleName);
                index.put((Descriptors.PackageRef)packageRef, attrs);
            }
            if (importAttrs != null) {
                String existingResolution = attrs.get("resolution:");
                String importResolution = importAttrs.get("resolution:");
                if ("optional".equals(existingResolution)) {
                    if (null == importResolution) {
                        attrs.remove("resolution:");
                    } else if ("mandatory".equals(importResolution)) {
                        attrs.put("resolution:", "mandatory");
                    }
                }
            }
            return true;
        }).collect(Collectors.groupingBy(entry -> index.get((Descriptors.PackageRef)entry.getKey()).get(INTERNAL_MODULE_DIRECTIVE), JPMSModuleInfoPlugin.mapFactory(), Collectors.toList()));
        String manuallyRequiredModules = instruction.getValue().get("modules");
        if (manuallyRequiredModules != null) {
            Strings.splitAsStream(manuallyRequiredModules).forEachOrdered(moduleToAdd -> requiresMap.computeIfAbsent(moduleToAdd, key -> Collections.emptyList()));
        }
        MapStream.of(requiresMap).sortedByKey().mapValue(referencedPackages -> MapStream.of(referencedPackages).keys().collect(Collectors.toList())).forEachOrdered((moduleName, referencedModulePackages) -> {
            Attrs moduleMappingAttrs = Optional.ofNullable(moduleInfoOptions.get((String)moduleName)).orElseGet(Attrs::new);
            if (Processor.isTrue(moduleMappingAttrs.get("ignore"))) {
                return;
            }
            boolean isTransitive = Optional.ofNullable(moduleMappingAttrs.get("transitive")).map(Processor::isTrue).orElseGet(() -> exports.values().stream().map(a -> a.get("uses:")).flatMap(Strings::splitAsStream).map(analyzer::getPackageRef).anyMatch(referencedModulePackages::contains));
            boolean isStatic = Optional.ofNullable(moduleMappingAttrs.get("static")).map(Processor::isTrue).orElseGet(() -> referencedModulePackages.isEmpty() || referencedModulePackages.stream().allMatch(p -> {
                Attrs attrs = index.get((Descriptors.PackageRef)p);
                if ("optional".equals(attrs.get("resolution:"))) {
                    return true;
                }
                return !dynamicImportPackages.isEmpty() && dynamicImportPackages.matches(p.getFQN());
            }));
            int access = (isTransitive ? 32 : 0) | (isStatic ? 64 : 0);
            builder.requires((String)moduleName, access, null);
        });
    }

    private void serviceLoaderProviders(ModuleInfoBuilder builder, Analyzer analyzer, Parameters provideCapabilities, Set<Descriptors.PackageRef> bcpEntries) {
        provideCapabilities.stream().filterKey(namespace -> Processor.removeDuplicateMarker(namespace).equals("osgi.serviceloader")).filterValue(attrs -> attrs.containsKey("register:")).values().collect(Collectors.groupingBy(attrs -> analyzer.getTypeRefFromFQN(attrs.get("osgi.serviceloader")), JPMSModuleInfoPlugin.mapFactory(), Collectors.toList())).forEach((typeRef, attrsList) -> {
            if (bcpEntries.contains(typeRef.getPackageRef())) {
                return;
            }
            Set<String> impls = attrsList.stream().map(attrs -> attrs.get("register:")).map(impl -> analyzer.getTypeRefFromFQN((String)impl)).filter(implTypeRef -> !bcpEntries.contains(implTypeRef.getPackageRef())).map(Descriptors.TypeRef::getBinary).collect(Collectors.toCollection(JPMSModuleInfoPlugin.setFactory()));
            if (!impls.isEmpty()) {
                builder.provides(typeRef.getBinary(), impls);
            }
        });
    }

    private void serviceLoaderUses(ModuleInfoBuilder builder, Analyzer analyzer, Parameters requireCapabilities, Set<Descriptors.PackageRef> bcpEntries) {
        requireCapabilities.stream().filterKey(key -> Processor.removeDuplicateMarker(key).equals("osgi.serviceloader")).values().forEachOrdered(attrs -> {
            Descriptors.TypeRef typeRef = analyzer.getTypeRefFromFQN(attrs.get("osgi.serviceloader"));
            if (!bcpEntries.contains(typeRef.getPackageRef())) {
                builder.uses(typeRef.getBinary());
            }
        });
    }

    private static <T> Supplier<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    private static <K, V> Supplier<Map<K, V>> mapFactory() {
        return LinkedHashMap::new;
    }

    static enum Access {
        CLOSED(0),
        OPEN(32),
        SYNTHETIC(4096),
        MANDATED(32768);

        private final int value;

        public static Set<Access> parse(String input) {
            switch (input.toLowerCase(Locale.ROOT)) {
                case "open": 
                case "0x0020": 
                case "32": {
                    return EnumSet.of(OPEN);
                }
                case "synthetic": 
                case "0x1000": 
                case "4096": {
                    return EnumSet.of(SYNTHETIC);
                }
                case "mandated": 
                case "0x8000": 
                case "32768": {
                    return EnumSet.of(MANDATED);
                }
            }
            if (input.indexOf(44) > -1) {
                return Strings.splitAsStream(input).map(Access::parse).flatMap(Collection::stream).collect(Collectors.toCollection(() -> EnumSet.noneOf(Access.class)));
            }
            int parsedValue = Integer.decode(input);
            return Arrays.stream(Access.values()).filter(a -> a.getValue() == parsedValue).findFirst().map(EnumSet::of).orElseThrow(() -> new IllegalArgumentException(input));
        }

        private Access(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

