/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.xa.impl;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionControlImpl;
import org.apache.aries.tx.control.service.xa.impl.Activator;
import org.apache.aries.tx.control.service.xa.impl.LocalResourceSupport;
import org.apache.aries.tx.control.service.xa.impl.NamedXAResourceImpl;
import org.apache.aries.tx.control.service.xa.impl.TransactionContextImpl;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoveryWorkAroundTransactionManager;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.transaction.control.recovery.RecoverableXAResource;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionControlImpl
extends AbstractTransactionControlImpl {
    private static final Logger logger = LoggerFactory.getLogger(TransactionControlImpl.class);
    private Map<String, Object> config;
    private final XidFactory xidFactory;
    private final HOWLLog log;
    private final RecoveryWorkAroundTransactionManager transactionManager;
    private final LocalResourceSupport localResourceSupport;
    private final ServiceTracker<RecoverableXAResource, RecoverableXAResource> recoverableResources;

    public TransactionControlImpl(BundleContext ctx, Map<String, Object> config) throws Exception {
        try {
            this.config = config;
            this.localResourceSupport = this.getLocalResourceSupport();
            this.xidFactory = new XidFactoryImpl();
            this.log = this.getLog(ctx);
            if (this.log != null) {
                this.log.doStart();
            }
            this.transactionManager = new RecoveryWorkAroundTransactionManager(this.getTimeout(), this.xidFactory, this.log);
            if (this.log != null) {
                this.recoverableResources = new ServiceTracker<RecoverableXAResource, RecoverableXAResource>(ctx, RecoverableXAResource.class, null){

                    public RecoverableXAResource addingService(ServiceReference<RecoverableXAResource> reference) {
                        final RecoverableXAResource resource = (RecoverableXAResource)super.addingService(reference);
                        if (resource.getId() == null) {
                            logger.warn("The RecoverableXAResource service with id {} does not have a name and will be ignored", reference.getProperty("service.id"));
                            return null;
                        }
                        if (TransactionControlImpl.this.log == null) {
                            logger.warn("A RecoverableXAResource with id {} has been registered, but recovery logging is disabled for this Transaction Control service. No recovery will be availble in the event of a Transaction Manager failure.", (Object)resource.getId());
                        }
                        TransactionControlImpl.this.transactionManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                            @Override
                            public void returnNamedXAResource(NamedXAResource namedXAResource) {
                                resource.releaseXAResource(((NamedXAResourceImpl)namedXAResource).xaResource);
                            }

                            @Override
                            public NamedXAResource getNamedXAResource() throws SystemException {
                                try {
                                    XAResource xaResource = resource.getXAResource();
                                    if (xaResource == null) {
                                        throw new IllegalStateException("The recoverable resource " + resource.getId() + " is currently unavailable");
                                    }
                                    return new NamedXAResourceImpl(resource.getId(), xaResource, TransactionControlImpl.this.transactionManager, false);
                                }
                                catch (Exception e) {
                                    throw new SystemException("Unable to get recoverable resource " + resource.getId() + ": " + e.getMessage());
                                }
                            }

                            @Override
                            public String getName() {
                                return resource.getId();
                            }
                        });
                        return resource;
                    }

                    public void removedService(ServiceReference<RecoverableXAResource> reference, RecoverableXAResource service) {
                        TransactionControlImpl.this.transactionManager.unregisterNamedXAResourceFactory(service.getId());
                    }
                };
                this.recoverableResources.open();
            } else {
                this.recoverableResources = null;
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private LocalResourceSupport getLocalResourceSupport() {
        Object o = this.config.getOrDefault("local.resources", (Object)LocalResourceSupport.ENFORCE_SINGLE);
        return o instanceof LocalResourceSupport ? (LocalResourceSupport)((Object)o) : LocalResourceSupport.valueOf(o.toString());
    }

    private HOWLLog getLog(BundleContext ctx) throws Exception {
        Object recovery = this.config.getOrDefault("recovery.log.enabled", Boolean.parseBoolean(String.valueOf(ctx.getProperty("org.apache.aries.tx.control.service.xa.recovery.log.enabled"))));
        if ((recovery instanceof Boolean ? (Boolean)recovery : Boolean.valueOf(recovery.toString())).booleanValue()) {
            String logFileExt = "log";
            String logFileName = "transaction";
            Object o = this.config.get("recovery.log.dir");
            String logFileDir = o == null ? ctx.getDataFile("recoveryLog").getAbsolutePath() : o.toString();
            File f = new File(logFileDir);
            if (f.exists() && !f.isDirectory()) {
                throw new IllegalArgumentException("The recovery log directory " + logFileDir + " is not a directory.");
            }
            HOWLLog log = new HOWLLog("org.objectweb.howl.log.BlockLogBuffer", 4, true, true, 50, logFileDir, logFileExt, logFileName, -1, 0, 2, 4, -1, true, this.xidFactory, null);
            return log;
        }
        return null;
    }

    private int getTimeout() {
        Object o = this.config.getOrDefault("transaction.timeout", 300);
        return o instanceof Integer ? (Integer)o : Integer.valueOf(o.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
            if (this.recoverableResources != null) {
                this.recoverableResources.close();
            }
        }
        finally {
            if (this.log != null) {
                try {
                    this.log.doStop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Field f = HOWLLog.class.getDeclaredField("logger");
                    f.setAccessible(true);
                    org.objectweb.howl.log.Logger howlLogger = (org.objectweb.howl.log.Logger)f.get(this.log);
                    f = org.objectweb.howl.log.Logger.class.getDeclaredField("bmgr");
                    f.setAccessible(true);
                    Object logBufferManager = f.get(howlLogger);
                    f = logBufferManager.getClass().getDeclaredField("flushManager");
                    f.setAccessible(true);
                    Thread flushThread = (Thread)f.get(logBufferManager);
                    if (flushThread.isAlive()) {
                        int toWait = Math.min(250, 2 * this.log.getFlushSleepTimeMilliseconds());
                        flushThread.join(toWait);
                        if (flushThread.isAlive()) {
                            flushThread.interrupt();
                            flushThread.join(toWait);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("An error ocurred while trying to close the HOWL flush thread.", (Throwable)e);
                }
            }
        }
    }

    public synchronized Dictionary<String, ?> getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(".")).forEach(e -> props.put((String)e.getKey(), e.getValue()));
        ((Dictionary)props).put("osgi.xa.enabled", Boolean.TRUE);
        ((Dictionary)props).put("osgi.local.enabled", this.getLocalResourceSupport() != LocalResourceSupport.DISABLED);
        ((Dictionary)props).put("osgi.recovery.enabled", this.log != null);
        ((Dictionary)props).put("service.description", "The Apache Aries Transaction Control Service for XA Transactions");
        ((Dictionary)props).put("service.vendor", "Apache Aries");
        return props;
    }

    public synchronized Activator.ChangeType changed(Map<String, Object> updated, boolean isRegistered) {
        Map<String, Object> replacement;
        Map<String, Object> current = this.filterFixedProps(this.config);
        if (current.equals(replacement = this.filterFixedProps(updated))) {
            this.config = updated;
            return Activator.ChangeType.SERVICE_PROPS;
        }
        return Activator.ChangeType.RECREATE;
    }

    private Map<String, Object> filterFixedProps(Map<String, Object> raw) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        this.copy(raw, filtered, "transaction.timeout");
        this.copy(raw, filtered, "recovery.log.enabled");
        this.copy(raw, filtered, "recovery.log.dir");
        this.copy(raw, filtered, "local.resources");
        return filtered;
    }

    private void copy(Map<String, Object> raw, Map<String, Object> filtered, String key) {
        if (raw.containsKey(key)) {
            filtered.put(key, raw.get(key));
        }
    }

    @Override
    protected AbstractTransactionContextImpl startTransaction(boolean readOnly) {
        return new TransactionContextImpl(this.transactionManager, readOnly, this.localResourceSupport);
    }
}

