/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.common.kex.dh.AbstractDHKeyExchange;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public abstract class AbstractDHServerKeyExchange
extends AbstractDHKeyExchange
implements ServerSessionHolder {
    protected AbstractDHServerKeyExchange() {
    }

    @Override
    public final ServerSession getServerSession() {
        return (ServerSession)((Object)this.getSession());
    }

    @Override
    public void init(Session s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(s, v_s, v_c, i_s, i_c);
        ValidateUtils.checkInstanceOf((Object)s, ServerSession.class, "Using a server side KeyExchange on a client: %s", (Object)s);
    }

    @Override
    public PublicKey getServerKey() {
        ServerSession session = this.getServerSession();
        return Objects.requireNonNull(session.getHostKey(), "No server key pair available").getPublic();
    }
}

