/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.kex.extension.DefaultClientKexExtensionHandler;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    public static final AttributeRepository.AttributeKey<Boolean> USE_DEFAULT_IDENTITIES = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<String> IDENTITY_AGENT = new AttributeRepository.AttributeKey();
    protected final Deque<String> currentAlgorithms = new LinkedList<String>();
    protected Iterator<PublicKeyIdentity> keys;
    protected PublicKeyIdentity current;
    protected List<NamedFactory<Signature>> factories;
    protected String chosenAlgorithm;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
        this.setCancellable(true);
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.releaseKeys();
        try {
            this.keys = this.createPublicKeyIterator(session, this);
        }
        catch (Error e) {
            this.warn("init({})[{}] failed ({}) to initialize session keys: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    protected Iterator<PublicKeyIdentity> createPublicKeyIterator(ClientSession session, SignatureFactoriesManager manager) throws Exception {
        return new UserAuthPublicKeyIterator(session, manager);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        boolean doHostBoundAuth;
        PublicKey pubKey;
        KeyPair keyPair;
        boolean debugEnabled = this.log.isDebugEnabled();
        String currentAlgorithm = null;
        if (this.current == null) {
            this.currentAlgorithms.clear();
            this.chosenAlgorithm = null;
        } else if (!this.currentAlgorithms.isEmpty()) {
            Set<String> knownServerAlgorithms;
            currentAlgorithm = this.currentAlgorithms.poll();
            if (this.chosenAlgorithm != null && (knownServerAlgorithms = session.getAttribute(DefaultClientKexExtensionHandler.SERVER_ALGORITHMS)) != null && knownServerAlgorithms.contains(this.chosenAlgorithm)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendAuthDataRequest({})[{}] server rejected publickey authentication with known signature algorithm {}", new Object[]{session, service, this.chosenAlgorithm});
                }
                currentAlgorithm = null;
            }
        }
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        do {
            if (currentAlgorithm == null) {
                try {
                    this.current = this.resolveAttemptedPublicKeyIdentity(session, service, reporter);
                }
                catch (Error e) {
                    this.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
                    throw new RuntimeSshException(e);
                }
                this.currentAlgorithms.clear();
                this.chosenAlgorithm = null;
                if (this.current == null) {
                    if (debugEnabled) {
                        this.log.debug("resolveAttemptedPublicKeyIdentity({})[{}] no more keys to send", (Object)session, (Object)service);
                    }
                    if (reporter != null) {
                        reporter.signalAuthenticationExhausted(session, service);
                    }
                    return false;
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendAuthDataRequest({})[{}] current key details: {}", new Object[]{session, service, this.current});
            }
            try {
                keyPair = this.current.getKeyIdentity();
            }
            catch (Error e) {
                this.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve key identity: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            pubKey = keyPair.getPublic();
            if (currentAlgorithm != null) continue;
            String keyType = KeyUtils.getKeyType(pubKey);
            TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            aliases.addAll(KeyUtils.getAllEquivalentKeyTypes(keyType));
            aliases.add(keyType);
            List<NamedFactory<Signature>> existingFactories = null;
            if (this.current instanceof SignatureFactoriesHolder) {
                existingFactories = ((SignatureFactoriesHolder)((Object)this.current)).getSignatureFactories();
            }
            if (GenericUtils.isEmpty(existingFactories)) {
                existingFactories = this.getSignatureFactories();
            }
            if (GenericUtils.isEmpty(existingFactories)) {
                existingFactories = session.getSignatureFactories();
            }
            if (existingFactories != null) {
                existingFactories.forEach(f -> {
                    if (aliases.contains(f.getName())) {
                        this.currentAlgorithms.add(f.getName());
                    }
                });
            }
            if (!GenericUtils.isEmpty(currentAlgorithm = this.currentAlgorithms.poll()) || !GenericUtils.isEmpty(currentAlgorithm = this.getDefaultSignatureAlgorithm(session, service, this.current, keyPair, keyType))) continue;
            currentAlgorithm = null;
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}] skipping {} key {}; no signature algorithm", new Object[]{session, service, keyType, KeyUtils.getFingerPrint(pubKey)});
            }
            if (reporter == null) continue;
            reporter.signalIdentitySkipped(session, service, keyPair);
        } while (currentAlgorithm == null);
        String name = this.getName();
        Integer hostBoundPubKeyVersion = session.getAttribute(DefaultClientKexExtensionHandler.HOSTBOUND_AUTHENTICATION);
        boolean bl = doHostBoundAuth = hostBoundPubKeyVersion != null && hostBoundPubKeyVersion == 0;
        if (doHostBoundAuth) {
            name = "publickey-hostbound-v00@openssh.com";
        }
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", new Object[]{session, service, name, currentAlgorithm, KeyUtils.getFingerPrint(pubKey)});
        }
        if (reporter != null) {
            reporter.signalAuthenticationAttempt(session, service, keyPair, currentAlgorithm);
        }
        this.chosenAlgorithm = currentAlgorithm;
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(currentAlgorithm);
        buffer.putPublicKey(pubKey);
        if (doHostBoundAuth) {
            buffer.putPublicKey(session.getServerKey());
        }
        this.setCancellable(true);
        session.writePacket(buffer);
        return true;
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session, String service) throws Exception {
        return this.resolveAttemptedPublicKeyIdentity(session, service, null);
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session, String service, PublicKeyAuthenticationReporter reporter) throws Exception {
        UserInteraction ui;
        if (this.keys != null) {
            while (this.keys.hasNext()) {
                PublicKeyIdentity nextKey = this.keys.next();
                KeyPair identity = nextKey.getKeyIdentity();
                PublicKey pk = identity.getPublic();
                if (pk instanceof OpenSshCertificate) {
                    OpenSshCertificate cert = (OpenSshCertificate)pk;
                    if (!OpenSshCertificate.Type.USER.equals((Object)cert.getType())) {
                        this.log.warn("resolveAttemptedPublicKeyIdentity({})[{}]: public key certificate {} {} (id={}) is not a user certificate", new Object[]{session, service, KeyUtils.getKeyType(cert), KeyUtils.getFingerPrint(cert), cert.getId()});
                        if (reporter == null) continue;
                        reporter.signalIdentitySkipped(session, service, identity);
                        continue;
                    }
                    if (!OpenSshCertificate.isValidNow(cert)) {
                        this.log.warn("resolveAttemptedPublicKeyIdentity({})[{}]: public key certificate {} {} (id={}) is not valid now", new Object[]{session, service, KeyUtils.getKeyType(cert), KeyUtils.getFingerPrint(cert), cert.getId()});
                        if (reporter == null) continue;
                        reporter.signalIdentitySkipped(session, service, identity);
                        continue;
                    }
                }
                return nextKey;
            }
        }
        if ((ui = session.getUserInteraction()) == null || !ui.isInteractionAllowed(session)) {
            return null;
        }
        KeyPair kp = ui.resolveAuthPublicKeyIdentityAttempt(session);
        if (kp == null) {
            return null;
        }
        return new KeyPairIdentity(this, session, kp);
    }

    protected String getDefaultSignatureAlgorithm(ClientSession session, String service, PublicKeyIdentity identity, KeyPair keyPair, String keyType) throws Exception {
        return null;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        KeyPair keyPair;
        int cmd;
        boolean doHostBoundAuth;
        String name = this.getName();
        PublicKey serverKey = null;
        Integer hostBoundPubKeyVersion = session.getAttribute(DefaultClientKexExtensionHandler.HOSTBOUND_AUTHENTICATION);
        boolean bl = doHostBoundAuth = hostBoundPubKeyVersion != null && hostBoundPubKeyVersion == 0;
        if (doHostBoundAuth) {
            name = "publickey-hostbound-v00@openssh.com";
            serverKey = session.getServerKey();
        }
        if ((cmd = buffer.getUByte()) != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            keyPair = this.current.getKeyIdentity();
        }
        catch (Error e) {
            this.warn("processAuthDataRequest({})[{}][{}] failed ({}) to retrieve key identity: {}", session, service, name, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        PublicKey pubKey = keyPair.getPublic();
        String rspKeyType = buffer.getString();
        PublicKey rspKey = buffer.getPublicKey();
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", new Object[]{session, service, name, rspKeyType, KeyUtils.getFingerPrint(rspKey)});
        }
        if (!KeyUtils.compareKeys(rspKey, pubKey)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched " + rspKeyType + " keys: expected=" + KeyUtils.getFingerPrint(pubKey) + ", actual=" + KeyUtils.getFingerPrint(rspKey));
        }
        if (!this.chosenAlgorithm.equalsIgnoreCase(rspKeyType)) {
            this.log.warn("processAuthDataRequest({})[{}][{}] sent algorithm {} but got back {} from {}", new Object[]{session, service, name, this.chosenAlgorithm, rspKeyType, session.getServerVersion()});
        }
        String username = session.getUsername();
        String algo = this.chosenAlgorithm;
        int length = GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(algo) + 256 + 64;
        buffer = session.createBuffer((byte)50, length);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(true);
        buffer.putString(algo);
        buffer.putPublicKey(pubKey);
        if (serverKey != null) {
            buffer.putPublicKey(serverKey);
        }
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}][{}]: signing with algorithm {}", new Object[]{session, service, name, algo});
        }
        byte[] sig = this.appendSignature(session, service, name, username, algo, pubKey, serverKey, buffer);
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (reporter != null) {
            reporter.signalSignatureAttempt(session, service, keyPair, algo, sig);
        }
        this.setCancellable(false);
        session.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession session, String service, String name, String username, String algo, PublicKey key, PublicKey serverKey, Buffer buffer) throws Exception {
        byte[] sig;
        byte[] id = session.getSessionId();
        int length = id.length + username.length() + service.length() + name.length() + algo.length() + 256 + 64;
        ByteArrayBuffer bs = new ByteArrayBuffer(length, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putBoolean(true);
        bs.putString(algo);
        bs.putPublicKey(key);
        if (serverKey != null) {
            bs.putPublicKey(serverKey);
        }
        byte[] contents = bs.getCompactData();
        try {
            Map.Entry<String, byte[]> result = this.current.sign(session, algo, contents);
            String factoryName = result.getKey();
            ValidateUtils.checkState(algo.equalsIgnoreCase(factoryName), "Mismatched signature type generated: requested=%s, used=%s", algo, factoryName);
            sig = result.getValue();
        }
        catch (Error e) {
            this.warn("appendSignature({})[{}][{}] failed ({}) to sign contents using {}: {}", session, service, name, e.getClass().getSimpleName(), algo, e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        String signatureAlgo = KeyUtils.getSignatureAlgorithm(algo, key);
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", new Object[]{session, service, name, signatureAlgo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(contents)});
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", new Object[]{session, service, name, signatureAlgo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(sig)});
        }
        bs.clear();
        bs.putString(signatureAlgo);
        bs.putBytes(sig);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
        return sig;
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session, String service, Buffer buffer) throws Exception {
        PublicKeyIdentity successfulKey = this.current;
        KeyPair identity = successfulKey == null ? null : successfulKey.getKeyIdentity();
        this.current = null;
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session, service, identity);
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        PublicKeyAuthenticationReporter reporter;
        PublicKeyIdentity keyUsed = this.current;
        if (partial) {
            this.current = null;
        }
        if ((reporter = session.getPublicKeyAuthenticationReporter()) != null) {
            KeyPair identity = keyUsed == null ? null : keyUsed.getKeyIdentity();
            reporter.signalAuthenticationFailure(session, service, identity, partial, serverMethods);
        }
    }

    @Override
    public void destroy() {
        try {
            this.releaseKeys();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.destroy();
    }

    protected void releaseKeys() throws IOException {
        this.currentAlgorithms.clear();
        this.current = null;
        this.chosenAlgorithm = null;
        try {
            if (this.keys instanceof Closeable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("releaseKeys({}) closing {}", (Object)this.getClientSession(), this.keys);
                }
                ((Closeable)((Object)this.keys)).close();
            }
        }
        finally {
            this.keys = null;
        }
    }
}

