/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.JSONOutputFormat;
import org.apache.hive.beeline.Rows;

public class JSONFileOutputFormat
extends JSONOutputFormat {
    JSONFileOutputFormat(BeeLine beeLine) {
        super(beeLine);
        this.generator.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
    }

    @Override
    void printHeader(Rows.Row header) {
    }

    @Override
    void printFooter(Rows.Row header) {
        ByteArrayOutputStream buf = (ByteArrayOutputStream)this.generator.getOutputTarget();
        try {
            this.generator.flush();
            String out = buf.toString(StandardCharsets.UTF_8.name());
            this.beeLine.output(out);
        }
        catch (IOException e) {
            this.beeLine.handleException(e);
        }
        buf.reset();
    }
}

