/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SlowLog
implements Iterable<Entry> {
    private final List<Entry> slowQueries = new ArrayList<Entry>();

    void addQuery(String query, long time) {
        this.slowQueries.add(new Entry(query, time));
    }

    void addAll(Iterable<Entry> queries) {
        for (Entry query : queries) {
            this.slowQueries.add(query);
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.slowQueries.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this.slowQueries) {
            sb.append(entry.queryId).append(" [").append(entry.time).append("ns]\n");
        }
        return sb.toString();
    }

    public static class Entry {
        final String queryId;
        final long time;

        Entry(String queryId, long time) {
            this.queryId = queryId;
            this.time = time;
        }
    }
}

