/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MetadataXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, Metadata metadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(metadata.getModelEncoding(), null);
        this.writeMetadata(metadata, "metadata", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeMetadata(Metadata metadata, String tagName, XmlSerializer serializer) throws IOException {
        if (metadata != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (metadata.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(metadata.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (metadata.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(metadata.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (metadata.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(metadata.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (metadata.getVersioning() != null) {
                this.writeVersioning(metadata.getVersioning(), "versioning", serializer);
            }
            if (metadata.getPlugins() != null && metadata.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = metadata.getPlugins().iterator();
                while (iter.hasNext()) {
                    Plugin o = (Plugin)iter.next();
                    this.writePlugin(o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        if (plugin != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (plugin.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(plugin.getName()).endTag(this.NAMESPACE, "name");
            }
            if (plugin.getPrefix() != null) {
                serializer.startTag(this.NAMESPACE, "prefix").text(plugin.getPrefix()).endTag(this.NAMESPACE, "prefix");
            }
            if (plugin.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(plugin.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSnapshot(Snapshot snapshot, String tagName, XmlSerializer serializer) throws IOException {
        if (snapshot != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (snapshot.getTimestamp() != null) {
                serializer.startTag(this.NAMESPACE, "timestamp").text(snapshot.getTimestamp()).endTag(this.NAMESPACE, "timestamp");
            }
            if (snapshot.getBuildNumber() != 0) {
                serializer.startTag(this.NAMESPACE, "buildNumber").text(String.valueOf(snapshot.getBuildNumber())).endTag(this.NAMESPACE, "buildNumber");
            }
            if (snapshot.isLocalCopy()) {
                serializer.startTag(this.NAMESPACE, "localCopy").text(String.valueOf(snapshot.isLocalCopy())).endTag(this.NAMESPACE, "localCopy");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeVersioning(Versioning versioning, String tagName, XmlSerializer serializer) throws IOException {
        if (versioning != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (versioning.getLatest() != null) {
                serializer.startTag(this.NAMESPACE, "latest").text(versioning.getLatest()).endTag(this.NAMESPACE, "latest");
            }
            if (versioning.getRelease() != null) {
                serializer.startTag(this.NAMESPACE, "release").text(versioning.getRelease()).endTag(this.NAMESPACE, "release");
            }
            if (versioning.getSnapshot() != null) {
                this.writeSnapshot(versioning.getSnapshot(), "snapshot", serializer);
            }
            if (versioning.getVersions() != null && versioning.getVersions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "versions");
                Iterator iter = versioning.getVersions().iterator();
                while (iter.hasNext()) {
                    String version = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "version").text(version).endTag(this.NAMESPACE, "version");
                }
                serializer.endTag(this.NAMESPACE, "versions");
            }
            if (versioning.getLastUpdated() != null) {
                serializer.startTag(this.NAMESPACE, "lastUpdated").text(versioning.getLastUpdated()).endTag(this.NAMESPACE, "lastUpdated");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

