/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.io.PathProcessor;

public class PathProcessorSupport
implements PathProcessor {
    protected static final boolean IS_WINDOWS = System.getProperty("os.name", "unknown").startsWith("Windows");
    protected static final boolean ATOMIC_MOVE = Boolean.parseBoolean(System.getProperty(PathProcessor.class.getName() + "ATOMIC_MOVE", "true"));

    @Override
    public boolean setLastModified(Path path, long value) throws IOException {
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(value));
            return true;
        }
        catch (FileSystemException e) {
            if (e instanceof AccessDeniedException) {
                throw e;
            }
            return false;
        }
    }

    @Override
    public void write(Path target, String data) throws IOException {
        this.writeFile(target, p -> Files.write(p, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]), false);
    }

    @Override
    public void write(Path target, InputStream source) throws IOException {
        this.writeFile(target, p -> Files.copy(source, p, StandardCopyOption.REPLACE_EXISTING), false);
    }

    @Override
    public void writeWithBackup(Path target, String data) throws IOException {
        this.writeFile(target, p -> Files.write(p, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]), true);
    }

    @Override
    public void writeWithBackup(Path target, InputStream source) throws IOException {
        this.writeFile(target, p -> Files.copy(source, p, StandardCopyOption.REPLACE_EXISTING), true);
    }

    public void writeFile(Path target, FileWriter writer, boolean doBackup) throws IOException {
        Objects.requireNonNull(target, "target is null");
        Objects.requireNonNull(writer, "writer is null");
        Path parent = Objects.requireNonNull(target.getParent(), "target must have parent");
        try (PathProcessor.CollocatedTempFile tempFile = this.newTempFile(target);){
            writer.write(tempFile.getPath());
            if (doBackup && Files.isRegularFile(target, new LinkOption[0])) {
                Files.copy(target, parent.resolve(target.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            tempFile.move();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long copy(Path source, Path target, PathProcessor.ProgressListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long copy(OutputStream os, InputStream is, PathProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        byte[] buffer = new byte[32768];
        while ((bytes = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                listener.progressed(ByteBuffer.wrap(buffer, 0, bytes));
            }
            catch (Exception exception) {}
        }
        return total;
    }

    @Override
    public void move(Path source, Path target) throws IOException {
        CopyOption[] copyOptionArray;
        if (ATOMIC_MOVE) {
            StandardCopyOption[] standardCopyOptionArray = new StandardCopyOption[3];
            standardCopyOptionArray[0] = StandardCopyOption.ATOMIC_MOVE;
            standardCopyOptionArray[1] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = standardCopyOptionArray;
            standardCopyOptionArray[2] = StandardCopyOption.COPY_ATTRIBUTES;
        } else {
            CopyOption[] copyOptionArray2 = new StandardCopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        CopyOption[] copyOption = copyOptionArray;
        if (IS_WINDOWS) {
            this.classicCopy(source, target);
        } else {
            Files.move(source, target, copyOption);
        }
        Files.deleteIfExists(source);
    }

    @Override
    public PathProcessor.TempFile newTempFile() throws IOException {
        final Path tempFile = Files.createTempFile("resolver", "tmp", new FileAttribute[0]);
        return new PathProcessor.TempFile(){

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void close() throws IOException {
                Files.deleteIfExists(tempFile);
            }
        };
    }

    @Override
    public PathProcessor.CollocatedTempFile newTempFile(final Path file) throws IOException {
        Path parent = Objects.requireNonNull(file.getParent(), "file must have parent");
        Files.createDirectories(parent, new FileAttribute[0]);
        final Path tempFile = parent.resolve(file.getFileName() + "." + Long.toUnsignedString(ThreadLocalRandom.current().nextLong()) + ".tmp");
        return new PathProcessor.CollocatedTempFile(){
            private final AtomicBoolean wantsMove = new AtomicBoolean(false);
            private final StandardCopyOption[] copyOption;
            {
                StandardCopyOption[] standardCopyOptionArray;
                if (ATOMIC_MOVE) {
                    StandardCopyOption[] standardCopyOptionArray2 = new StandardCopyOption[2];
                    standardCopyOptionArray2[0] = StandardCopyOption.ATOMIC_MOVE;
                    standardCopyOptionArray = standardCopyOptionArray2;
                    standardCopyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
                } else {
                    StandardCopyOption[] standardCopyOptionArray3 = new StandardCopyOption[1];
                    standardCopyOptionArray = standardCopyOptionArray3;
                    standardCopyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
                }
                this.copyOption = standardCopyOptionArray;
            }

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void move() {
                this.wantsMove.set(true);
            }

            @Override
            public void close() throws IOException {
                if (this.wantsMove.get()) {
                    if (IS_WINDOWS) {
                        PathProcessorSupport.this.classicCopy(tempFile, file);
                    } else {
                        Files.move(tempFile, file, this.copyOption);
                    }
                }
                Files.deleteIfExists(tempFile);
            }
        };
    }

    protected void classicCopy(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        try (InputStream is = Files.newInputStream(source, new OpenOption[0]);
             OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            int bytes;
            while ((bytes = is.read(array)) >= 0) {
                os.write(array, 0, bytes);
            }
        }
    }

    @FunctionalInterface
    public static interface FileWriter {
        public void write(Path var1) throws IOException;
    }
}

