/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PatternSet
implements Serializable,
InputLocationTracker {
    final List<String> includes;
    final List<String> excludes;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected PatternSet(Builder builder) {
        this.includes = ImmutableCollections.copy(builder.includes != null ? builder.includes : (builder.base != null ? builder.base.includes : null));
        this.excludes = ImmutableCollections.copy(builder.excludes != null ? builder.excludes : (builder.base != null ? builder.base.excludes : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    @Nonnull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return PatternSet.newBuilder(this);
    }

    @Nonnull
    public PatternSet withIncludes(Collection<String> includes) {
        return PatternSet.newBuilder(this, true).includes(includes).build();
    }

    @Nonnull
    public PatternSet withExcludes(Collection<String> excludes) {
        return PatternSet.newBuilder(this, true).excludes(excludes).build();
    }

    @Nonnull
    public static PatternSet newInstance() {
        return PatternSet.newInstance(true);
    }

    @Nonnull
    public static PatternSet newInstance(boolean withDefaults) {
        return PatternSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PatternSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from) {
        return PatternSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PatternSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "PatternSet [includes: {" + this.getIncludes().stream().collect(Collectors.joining(", ")) + "}, excludes: {" + this.getExcludes().stream().collect(Collectors.joining(", ")) + "}]";
    }

    @NotThreadSafe
    public static class Builder {
        PatternSet base;
        Collection<String> includes;
        Collection<String> excludes;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(PatternSet base, boolean forceCopy) {
            if (forceCopy) {
                this.includes = base.includes;
                this.excludes = base.excludes;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PatternSet build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes)) {
                return this.base;
            }
            return new PatternSet(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

