/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.logging.LogRepository;
import org.slf4j.LoggerFactory;

public class LogRepositoryFactory {
    public static final String LOG_REPOSITORY_CLASS_NAME = "org.apache.nifi.logging.repository.StandardLogRepository";
    private static final ConcurrentMap<String, LogRepository> repositoryMap = new ConcurrentHashMap<String, LogRepository>();
    private static final Class<LogRepository> logRepositoryClass;

    public static LogRepository getRepository(String componentId) {
        LogRepository repository = (LogRepository)repositoryMap.get(Objects.requireNonNull(componentId));
        if (repository == null) {
            try {
                repository = logRepositoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            LogRepository oldRepository = repositoryMap.putIfAbsent(componentId, repository);
            if (oldRepository != null) {
                repository = oldRepository;
            }
        }
        return repository;
    }

    public static void purge() {
        repositoryMap.clear();
    }

    public static LogRepository removeRepository(String componentId) {
        return (LogRepository)repositoryMap.remove(Objects.requireNonNull(componentId));
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(LOG_REPOSITORY_CLASS_NAME, true, LogRepositoryFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName(LOG_REPOSITORY_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e1) {
                LoggerFactory.getLogger(LogRepositoryFactory.class).error("Unable to find class {}; logging may not work properly", (Object)LOG_REPOSITORY_CLASS_NAME);
            }
        }
        logRepositoryClass = clazz;
    }
}

