/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.bucket.BucketItemType;
import org.apache.nifi.registry.extension.bundle.BundleType;

@XmlRootElement
public class Bundle
extends BucketItem {
    @NotNull
    private BundleType bundleType;
    @NotBlank
    private String groupId;
    @NotBlank
    private String artifactId;
    @Min(value=0L)
    private @Min(value=0L) long versionCount;

    public Bundle() {
        super(BucketItemType.Bundle);
    }

    @Schema(description="The type of the extension bundle")
    public BundleType getBundleType() {
        return this.bundleType;
    }

    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType;
    }

    @Schema(description="The group id of the extension bundle")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The artifact id of the extension bundle")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Schema(description="The number of versions of this extension bundle.", accessMode=Schema.AccessMode.READ_ONLY)
    public long getVersionCount() {
        return this.versionCount;
    }

    public void setVersionCount(long versionCount) {
        this.versionCount = versionCount;
    }
}

