/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.AuthorizationObservationContext;
import org.springframework.security.authorization.AuthorizationObservationConvention;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class ObservationReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T>,
MethodAuthorizationDeniedHandler {
    private final ObservationRegistry registry;
    private final ReactiveAuthorizationManager<T> delegate;
    private ObservationConvention<AuthorizationObservationContext<?>> convention = new AuthorizationObservationConvention();
    private MethodAuthorizationDeniedHandler handler = new ThrowingMethodAuthorizationDeniedHandler();

    public ObservationReactiveAuthorizationManager(ObservationRegistry registry, ReactiveAuthorizationManager<T> delegate) {
        this.registry = registry;
        this.delegate = delegate;
        if (delegate instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler h;
            this.handler = h = (MethodAuthorizationDeniedHandler)((Object)delegate);
        }
    }

    @Override
    public Mono<AuthorizationResult> authorize(Mono<Authentication> authentication, T object) {
        AuthorizationObservationContext context = new AuthorizationObservationContext(object);
        Mono wrapped = authentication.mapNotNull(auth -> {
            context.setAuthentication((Authentication)auth);
            return context.getAuthentication();
        });
        return Mono.deferContextual(contextView -> {
            Observation observation = Observation.createNotStarted(this.convention, () -> context, (ObservationRegistry)this.registry).parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return this.delegate.authorize((Mono<Authentication>)wrapped, object).doOnSuccess(result -> {
                context.setAuthorizationResult((AuthorizationResult)result);
                if (result == null || !result.isGranted()) {
                    observation.error((Throwable)new AccessDeniedException("Access Denied"));
                }
                observation.stop();
            }).doOnCancel(() -> ((Observation)observation).stop()).doOnError(t -> {
                observation.error(t);
                observation.stop();
            });
        });
    }

    public void setObservationConvention(ObservationConvention<AuthorizationObservationContext<?>> convention) {
        Assert.notNull(convention, (String)"The observation convention cannot be null");
        this.convention = convention;
    }

    @Override
    public @Nullable Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public @Nullable Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

