/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class SearchStream
extends TupleStream
implements Expressible {
    private String zkHost;
    private ModifiableSolrParams params;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    private Iterator<SolrDocument> documentIterator;
    protected StreamComparator comp;

    public SearchStream() {
    }

    public SearchStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("buckets") || namedParam.getName().equals("bucketSorts") || namedParam.getName().equals("limit")) continue;
            params.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, params);
    }

    void init(String zkHost, String collection, ModifiableSolrParams params) throws IOException {
        this.zkHost = zkHost;
        this.params = params;
        if (this.params.get("q") == null) {
            this.params.add("q", "*:*");
        }
        this.collection = collection;
        if (params.get("sort") != null) {
            this.comp = this.parseComp(params.get("sort"), params.get("fl"));
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression("search");
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        for (Map.Entry<String, String[]> param : this.params.getMap().entrySet()) {
            for (String val : param.getValue()) {
                expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), val.replace("\"", "\\\"")));
            }
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName("search");
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = new CloudSolrClient.Builder(hosts, Optional.empty()).build();
        }
        QueryRequest request = new QueryRequest(this.params, SolrRequest.METHOD.POST);
        try {
            QueryResponse response = (QueryResponse)request.process(this.cloudSolrClient, this.collection);
            SolrDocumentList docs = response.getResults();
            this.documentIterator = docs.iterator();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.documentIterator.hasNext()) {
            Tuple tuple = new Tuple();
            SolrDocument doc = this.documentIterator.next();
            for (Map.Entry<String, Object> entry : doc.entrySet()) {
                tuple.put(entry.getKey(), entry.getValue());
            }
            return tuple;
        }
        return Tuple.EOF();
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comp;
    }

    private StreamComparator parseComp(String sort, String fl) throws IOException {
        HashSet<String> fieldSet = null;
        if (fl != null) {
            String[] fls;
            fieldSet = new HashSet<String>();
            for (String f : fls = fl.split(",")) {
                fieldSet.add(f.trim());
            }
        }
        String[] sorts = sort.split(",");
        StreamComparator[] comps = new StreamComparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            if (spec.length != 2) {
                throw new IOException("Invalid sort spec:" + s);
            }
            String fieldName = spec[0].trim();
            String order = spec[1].trim();
            if (fieldSet != null && !fieldSet.contains(spec[0])) {
                throw new IOException("Fields in the sort spec must be included in the field list:" + spec[0]);
            }
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        if (comps.length > 1) {
            return new MultipleFieldComparator(comps);
        }
        return comps[0];
    }
}

