/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.codec.net.URLCodec;

public class LaxURLCodec
extends URLCodec {
    public static LaxURLCodec DEFAULT;
    public static BitSet EXPANDED_URI_SAFE;
    public static BitSet QUERY_SAFE;

    public LaxURLCodec(String encoding) {
        super(encoding);
    }

    public static final byte[] decodeUrlLoose(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37 && i + 2 < bytes.length) {
                int u = Character.digit((char)bytes[i + 1], 16);
                int l = Character.digit((char)bytes[i + 2], 16);
                if (u > -1 && l > -1) {
                    int c = (u << 4) + l;
                    buffer.write((char)c);
                    i += 2;
                    continue;
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    public String encode(BitSet safe, String pString, String cs) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(LaxURLCodec.encodeUrl((BitSet)safe, (byte[])pString.getBytes(cs)), StandardCharsets.US_ASCII);
    }

    static {
        int i;
        DEFAULT = new LaxURLCodec(StandardCharsets.UTF_8.name());
        EXPANDED_URI_SAFE = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            EXPANDED_URI_SAFE.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            EXPANDED_URI_SAFE.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            EXPANDED_URI_SAFE.set(i);
        }
        EXPANDED_URI_SAFE.set(45);
        EXPANDED_URI_SAFE.set(126);
        EXPANDED_URI_SAFE.set(95);
        EXPANDED_URI_SAFE.set(46);
        EXPANDED_URI_SAFE.set(42);
        EXPANDED_URI_SAFE.set(47);
        EXPANDED_URI_SAFE.set(61);
        EXPANDED_URI_SAFE.set(38);
        EXPANDED_URI_SAFE.set(43);
        EXPANDED_URI_SAFE.set(44);
        EXPANDED_URI_SAFE.set(58);
        EXPANDED_URI_SAFE.set(59);
        EXPANDED_URI_SAFE.set(64);
        EXPANDED_URI_SAFE.set(36);
        EXPANDED_URI_SAFE.set(33);
        EXPANDED_URI_SAFE.set(41);
        EXPANDED_URI_SAFE.set(40);
        EXPANDED_URI_SAFE.set(37);
        EXPANDED_URI_SAFE.set(124);
        EXPANDED_URI_SAFE.set(39);
        QUERY_SAFE = new BitSet(256);
        QUERY_SAFE.or(EXPANDED_URI_SAFE);
        QUERY_SAFE.set(123);
        QUERY_SAFE.set(125);
        QUERY_SAFE.set(91);
        QUERY_SAFE.set(93);
        QUERY_SAFE.set(94);
        QUERY_SAFE.set(63);
    }
}

