/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;
import opennlp.uima.sentdetect.AbstractSentenceDetector;
import opennlp.uima.sentdetect.SentenceModelResource;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class SentenceDetector
extends AbstractSentenceDetector {
    private SentenceDetectorME sentenceDetector;
    private Feature probabilityFeature;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        SentenceModel model;
        super.initialize(context);
        try {
            SentenceModelResource modelResource = (SentenceModelResource)context.getResourceObject("opennlp.uima.ModelName");
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.sentenceDetector = new SentenceDetectorME(model);
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.sentenceType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    @Override
    protected Span[] detectSentences(String text) {
        return this.sentenceDetector.sentPosDetect((CharSequence)text);
    }

    @Override
    protected void postProcessAnnotations(AnnotationFS[] sentences) {
        if (this.probabilityFeature != null) {
            double[] sentenceProbabilities = this.sentenceDetector.probs();
            for (int i = 0; i < sentences.length; ++i) {
                sentences[i].setDoubleValue(this.probabilityFeature, sentenceProbabilities[i]);
            }
        }
    }

    public void destroy() {
        this.sentenceDetector = null;
    }
}

