/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.doccat.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class DoccatTrainerTool
extends AbstractTrainerTool<DocumentSample, TrainerToolParams> {
    public DoccatTrainerTool() {
        super(DocumentSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Trainer for the learnable document categorizer";
    }

    @Override
    public void run(String format, String[] args) {
        DoccatModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("document categorizer model", modelOutFile);
        FeatureGenerator[] featureGenerators = DoccatTrainerTool.createFeatureGenerators(((TrainerToolParams)this.params).getFeatureGenerators());
        try {
            DoccatFactory factory = DoccatFactory.create((String)((TrainerToolParams)this.params).getFactory(), (FeatureGenerator[])featureGenerators);
            model = DocumentCategorizerME.train((String)((TrainerToolParams)this.params).getLang(), (ObjectStream)this.sampleStream, (TrainingParameters)this.mlParams, (DoccatFactory)factory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("document categorizer", modelOutFile, (BaseModel)model);
    }

    static FeatureGenerator[] createFeatureGenerators(String featureGeneratorsNames) {
        if (featureGeneratorsNames == null) {
            return new FeatureGenerator[]{new BagOfWordsFeatureGenerator()};
        }
        String[] classes = featureGeneratorsNames.split(",");
        FeatureGenerator[] featureGenerators = new FeatureGenerator[classes.length];
        for (int i = 0; i < featureGenerators.length; ++i) {
            featureGenerators[i] = (FeatureGenerator)ExtensionLoader.instantiateExtension(FeatureGenerator.class, (String)classes[i]);
        }
        return featureGenerators;
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

