/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;

public class PrintWriterServletOutputStream
extends ServletOutputStream {
    PrintWriter mPrintWriter;
    private String characterEncoding;

    public PrintWriterServletOutputStream(PrintWriter pO) {
        this(pO, null);
    }

    public PrintWriterServletOutputStream(PrintWriter pw, String encoding) {
        this.mPrintWriter = pw;
        this.characterEncoding = encoding;
    }

    public void write(int pVal) throws IOException {
        this.mPrintWriter.write(pVal);
    }

    public void write(byte[] pBuf) throws IOException {
        this.write(pBuf, 0, pBuf.length);
    }

    public void write(byte[] pBuf, int pOffset, int pLength) throws IOException {
        String strValue = null;
        if (this.characterEncoding != null && !"".equals(this.characterEncoding)) {
            try {
                strValue = new String(pBuf, pOffset, pLength, this.characterEncoding);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        if (strValue == null) {
            strValue = new String(pBuf, pOffset, pLength);
        }
        this.mPrintWriter.write(strValue);
    }

    public void flush() throws IOException {
        this.mPrintWriter.flush();
    }

    public void close() throws IOException {
        this.mPrintWriter.close();
    }

    public void print(String pVal) throws IOException {
        this.mPrintWriter.print(pVal);
    }

    public void println(String pVal) throws IOException {
        this.mPrintWriter.println(pVal);
    }

    public void println() throws IOException {
        this.mPrintWriter.println();
    }
}

