/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.rewriter.htmlcleaner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewriter;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingContext;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingException;
import org.apache.portals.applications.webcontent2.rewriter.Sink;
import org.apache.portals.applications.webcontent2.rewriter.Source;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.DefaultSerializerFactory;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.SerializerFactory;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagNodeVisitor;
import org.htmlcleaner.XPather;
import org.htmlcleaner.XPatherException;

public class HtmlCleanerContentRewriter
implements ContentRewriter {
    private HtmlCleaner cleaner;
    private SerializerFactory serializerFactory;
    private String sinkEncoding = "UTF-8";
    private String xpathExpression;
    private boolean innerHtmlOnly;
    private String[] transformationInfos;
    private List<TagNodeVisitor> tagNodeVisitors;

    public SerializerFactory getSerializerFactory() {
        if (this.serializerFactory != null) {
            return this.serializerFactory;
        }
        DefaultSerializerFactory defaultSerializerFactory = new DefaultSerializerFactory();
        defaultSerializerFactory.setSerializerClass(SimpleHtmlSerializer.class);
        return defaultSerializerFactory;
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    public String getSinkEncoding() {
        return this.sinkEncoding;
    }

    public void setSinkEncoding(String sinkEncoding) {
        this.sinkEncoding = sinkEncoding;
    }

    public String getXpathExpression() {
        return this.xpathExpression;
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public boolean isInnerHtmlOnly() {
        return this.innerHtmlOnly;
    }

    public void setInnerHtmlOnly(boolean innerHtmlOnly) {
        this.innerHtmlOnly = innerHtmlOnly;
    }

    public CleanerTransformations getCleanerTransformations() {
        return this.getHtmlCleaner().getProperties().getCleanerTransformations();
    }

    public void setCleanerTransformations(CleanerTransformations cleanerTransformations) {
        this.getHtmlCleaner().getProperties().setCleanerTransformations(cleanerTransformations);
    }

    public String[] getCleanerTransformationStringArray() {
        if (this.transformationInfos == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] transInfos = new String[this.transformationInfos.length];
        System.arraycopy(this.transformationInfos, 0, transInfos, 0, this.transformationInfos.length);
        return transInfos;
    }

    public void setCleanerTransformationStringArray(String[] transInfos) {
        if (transInfos == null) {
            this.transformationInfos = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            this.transformationInfos = new String[transInfos.length];
            System.arraycopy(transInfos, 0, this.transformationInfos, 0, transInfos.length);
        }
        TreeMap<String, String> transInfosMap = new TreeMap<String, String>();
        for (String transInfo : this.transformationInfos) {
            int index = transInfo.indexOf(61);
            String key = index <= 0 ? transInfo : transInfo.substring(0, index);
            String value = index <= 0 ? null : transInfo.substring(index + 1);
            transInfosMap.put(key, value);
        }
        this.setCleanerTransformations(new CleanerTransformations(transInfosMap));
    }

    public List<TagNodeVisitor> getTagNodeVisitors() {
        if (this.tagNodeVisitors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.tagNodeVisitors);
    }

    public void setTagNodeVisitors(List<TagNodeVisitor> tagNodeVisitors) {
        this.tagNodeVisitors = new ArrayList<TagNodeVisitor>();
        if (tagNodeVisitors != null) {
            this.tagNodeVisitors.addAll(tagNodeVisitors);
        }
    }

    public void addTagNodeVisitor(TagNodeVisitor tagNodeVisitor) {
        if (this.tagNodeVisitors == null) {
            this.tagNodeVisitors = new ArrayList<TagNodeVisitor>();
        }
        this.tagNodeVisitors.add(tagNodeVisitor);
    }

    public void removeTagNodeVisitor(TagNodeVisitor tagNodeVisitor) {
        if (this.tagNodeVisitors != null) {
            this.tagNodeVisitors.remove(tagNodeVisitor);
        }
    }

    public void removeAllTagNodeVisitors() {
        if (this.tagNodeVisitors != null) {
            this.tagNodeVisitors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewrite(Source source, Sink sink, ContentRewritingContext context) throws ContentRewritingException, IOException {
        BufferedWriter bw;
        Writer writer;
        BufferedReader br;
        Reader reader;
        block17: {
            Serializer serializer = null;
            try {
                serializer = this.getSerializerFactory().createSerializer(this.getHtmlCleaner());
            }
            catch (Exception e) {
                throw new ContentRewritingException("Failed to create serializer. " + e, e);
            }
            reader = null;
            br = null;
            writer = null;
            bw = null;
            try {
                reader = source.getReader();
                br = new BufferedReader(reader);
                writer = sink.getWriter();
                bw = new BufferedWriter(writer);
                TagNode rootTagNode = this.getHtmlCleaner().clean((Reader)br);
                ArrayList<TagNode> contentTagNodes = null;
                if (StringUtils.isNotEmpty((String)this.getXpathExpression())) {
                    try {
                        contentTagNodes = new ArrayList<TagNode>();
                        XPather xpather = new XPather(this.getXpathExpression());
                        Object[] items = xpather.evaluateAgainstNode(rootTagNode);
                        if (items != null) {
                            for (Object item : items) {
                                if (!(item instanceof TagNode)) continue;
                                contentTagNodes.add((TagNode)item);
                            }
                        }
                    }
                    catch (XPatherException e) {
                        throw new ContentRewritingException("Failed to evaluate xpath: " + this.getXpathExpression() + ". " + (Object)((Object)e), e);
                    }
                }
                if (contentTagNodes != null && !contentTagNodes.isEmpty()) {
                    for (TagNode contentTagNode : contentTagNodes) {
                        for (TagNodeVisitor tagNodeVisitor : this.getTagNodeVisitors()) {
                            contentTagNode.traverse(tagNodeVisitor);
                        }
                    }
                    if (this.isInnerHtmlOnly()) {
                        String innerHtml = null;
                        for (TagNode contentTagNode : contentTagNodes) {
                            innerHtml = this.getHtmlCleaner().getInnerHtml(contentTagNode);
                            if (innerHtml == null) continue;
                            writer.write(innerHtml);
                        }
                    } else {
                        for (TagNode contentTagNode : contentTagNodes) {
                            serializer.write(contentTagNode, writer, this.getSinkEncoding());
                        }
                    }
                    break block17;
                }
                for (TagNodeVisitor tagNodeVisitor : this.getTagNodeVisitors()) {
                    rootTagNode.traverse(tagNodeVisitor);
                }
                serializer.write(rootTagNode, writer, this.getSinkEncoding());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly(bw);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)bw);
        IOUtils.closeQuietly((Writer)writer);
    }

    protected HtmlCleaner getHtmlCleaner() {
        if (this.cleaner == null) {
            this.cleaner = this.createHtmlCleaner();
        }
        return this.cleaner;
    }

    protected HtmlCleaner createHtmlCleaner() {
        HtmlCleaner htmlCleaner = new HtmlCleaner();
        htmlCleaner.getProperties().setOmitXmlDeclaration(true);
        htmlCleaner.getProperties().setOmitDoctypeDeclaration(true);
        return htmlCleaner;
    }
}

