/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.rewriter.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.portals.applications.webcontent2.rewriter.Sink;

public class StreamSink
implements Sink {
    private OutputStream output;
    private String encoding;
    private Writer writer;

    public StreamSink(OutputStream output) {
        this(output, null);
    }

    public StreamSink(OutputStream output, String encoding) {
        if (output == null) {
            throw new IllegalArgumentException("output must not be null.");
        }
        this.output = output;
        this.encoding = encoding;
    }

    public StreamSink(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null.");
        }
        this.writer = writer;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this sink.");
        }
        return this.output;
    }

    @Override
    public Writer getWriter() throws IOException {
        if (this.output != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this sink.");
        }
        if (this.writer == null) {
            this.writer = this.encoding == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, this.encoding);
        }
        return this.writer;
    }
}

