/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;
import org.apache.portals.applications.webcontent2.portlet.proxy.MimeResponseSink;
import org.apache.portals.applications.webcontent2.proxy.RequestContext;
import org.apache.portals.applications.webcontent2.rewriter.Sink;

public class PortletRequestContext
implements RequestContext {
    private final PortletRequest request;
    private final PortletResponse response;
    private int responseStatus;
    private List<Cookie> responseCookies;
    private Sink sink;

    public PortletRequestContext(PortletRequest request, PortletResponse response) {
        this.request = request;
        this.response = response;
    }

    public PortletRequest getPortletRequest() {
        return this.request;
    }

    public PortletResponse getPortletResponse() {
        return this.response;
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getMethod() {
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getMethod();
        }
        return "GET";
    }

    public String getRequestBasePath() {
        return "";
    }

    public String getPathInfo() {
        return "/";
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public String getQueryString() {
        return null;
    }

    public Enumeration getHeaderNames() {
        return this.request.getPropertyNames();
    }

    public Enumeration getHeaders(String name) {
        return this.request.getProperties(name);
    }

    public String getHeader(String name) {
        return this.request.getProperty(name);
    }

    public InputStream getInputStream() throws IOException {
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getPortletInputStream();
        }
        return null;
    }

    public void setStatus(int sc) {
        this.responseStatus = sc;
    }

    public int getStatus() {
        return this.responseStatus;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.response instanceof ActionResponse) {
            ((ActionResponse)this.response).sendRedirect(location);
        }
    }

    public void setHeader(String name, String value) {
        this.response.setProperty(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setProperty(name, Integer.toString(value));
    }

    public void addCookie(Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new ArrayList<Cookie>();
        }
        this.responseCookies.add(cookie);
    }

    public List<Cookie> getCookies() {
        if (this.responseCookies == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.responseCookies);
    }

    public Sink getSink() {
        if (this.sink == null) {
            if (!(this.response instanceof MimeResponse)) {
                throw new IllegalStateException("MimeResponse is required to create a sink.");
            }
            this.sink = new MimeResponseSink((MimeResponse)this.response);
        }
        return this.sink;
    }
}

