/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleRedirectionCommand
extends AbstractProxyCommand {
    private static Logger log = LoggerFactory.getLogger(HandleRedirectionCommand.class);

    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        ProxyMapping proxyMapping;
        HttpResponse httpResponse = context.getHttpResponse();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode < 300 || statusCode >= 304) {
            return false;
        }
        String location = null;
        Header locationHeader = httpResponse.getFirstHeader("Location");
        if (locationHeader != null) {
            location = locationHeader.getValue();
        }
        if (location == null) {
            throw new ReverseProxyException(502, "No location header.");
        }
        if (location.startsWith("/")) {
            URI targetURI = context.getRemoteURI();
            String scheme = targetURI.getScheme();
            int port = targetURI.getPort();
            StringBuilder uriBuilder = new StringBuilder(40).append(targetURI.getScheme()).append("://").append(targetURI.getHost());
            if (port > 0 && (port != 80 && "http".equals(scheme) || port != 443 && "https".equals(scheme))) {
                uriBuilder.append(':').append(port);
            }
            uriBuilder.append(location);
            location = uriBuilder.toString();
        }
        URI locationURI = null;
        try {
            locationURI = URI.create(location);
        }
        catch (Exception e) {
            log.error("Invalid redirect location: '{}'.", (Object)location);
            return true;
        }
        String localPath = context.getResolvedMapping().resolveLocalFromRemote(locationURI);
        if (localPath == null && (proxyMapping = context.getProxyMappingRegistry().findProxyMappingByRemoteURI(locationURI)) != null) {
            localPath = proxyMapping.resolveLocalFromRemote(locationURI);
        }
        String redirectLocation = null;
        if (localPath == null) {
            log.warn("Cannot translate the redirect location to local path. {}", (Object)location);
            redirectLocation = location;
        } else {
            redirectLocation = context.getRequestContext().getRequestBasePath() + localPath;
        }
        context.getRequestContext().sendRedirect(redirectLocation);
        return true;
    }
}

