/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

/**
 * The <CODE>HttpReverseProxyException</CODE> class defines a general exception
 * that an http reverse proxy component can throw when it is unable to perform its operation
 * successfully.
 * 
 * @version $Id: HttpReverseProxyException.java 821934 2009-10-05 17:50:07Z woonsan $
 */
public class HttpReverseProxyException extends Exception {

    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new HttpReverseProxyException exception.
     */
    public HttpReverseProxyException() {
        super();
    }

    /**
     * Constructs a new HttpReverseProxyException exception with the given message.
     *
     * @param   message
     *          the exception message
     */
    public HttpReverseProxyException(String message) {
        super(message);
    }

    /**
     * Constructs a new HttpReverseProxyException exception with the nested exception.
     *
     * @param   nested
     *          the nested exception
     */
    public HttpReverseProxyException(Throwable nested) {
        super(nested);
    }

    /**
     * Constructs a new HttpReverseProxyException exception when the container needs to do
     * the following:
     * <ul>
     * <li>throw an exception 
     * <li>include the "nested" exception
     * <li>include a description message
     * </ul>
     *
     * @param   msg
     *          the exception message
     * @param   nested
     *          the nested exception
     */
    public HttpReverseProxyException(String msg, Throwable nested) {
        super(msg, nested);
    }
    
}
