/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

import java.util.Map;
import java.util.Set;


/**
 * proxy path mapper interface for http reverse proxy service.
 * 
 * @version $Id: HttpReverseProxyPathMapper.java 965693 2010-07-20 00:35:21Z woonsan $
 */
public interface HttpReverseProxyPathMapper
{
    
    /**
     * Returns the name
     * @return
     */
    public String getName();
    
    /**
     * Returns the local base path to be mapped to remote base url.
     * @return
     */
    public String getLocalBasePath();
    
    /**
     * Returns the remote base url mapped by the local path.
     * @return
     */
    public String getRemoteBaseURL();
    
    /**
     * Generates a remote url mapped by the path.
     * <P>It returns a translated remote URL or null if the translation fails.</P>
     * @param localPath
     * @return
     */
    public String getRemoteURL(String localPath);
    
    /**
     * Generates a local url mapped by the remote url.
     * <P>It returns a translated local path or null if the translation fails.</P>
     * @param remoteURL
     * @return
     */
    public String getLocalPath(String remoteURL);
    
    /**
     * Returns true when the reverse proxy path resources are secured to allowed roles only. 
     * @return
     */
    public boolean isSecured();
    
    /**
     * Returns the role names allowed to reverse proxy path resources.
     * @return
     */
    public Set<String> getAllowedRoles();
    
    /**
     * Returns default request headers to the remote URL target.
     * @return
     */
    public Map<String, String> getDefaultRequestHeaders();
    
    /**
     * Returns default request cookies to the remote URL target.
     * @return
     */
    public Map<String, String> getDefaultRequestCookies();
    
    /**
     * Returns the name set of cookies which path should be rewritten.
     * @return
     */
    public Set<String> getRewriteCookiePathIncludes();
    
    /**
     * Returns the name set of cookies which path should not be rewritten.
     * @return
     */
    public Set<String> getRewriteCookiePathExcludes();
    
}