/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.rewriter.rules.impl;

import org.apache.portals.applications.webcontent.rewriter.rules.Attribute;
import org.apache.portals.applications.webcontent.rewriter.rules.Rule;

/**
 * Attribute
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: AttributeImpl.java 764612 2009-04-13 21:17:59Z taylor $
 */
public class AttributeImpl extends IdentifiedImpl implements Attribute
{
    private Rule rule;
    private String ruleId;
        
    public void setId(String id)
    {
        if (id != null)
        {
            this.id = id.toUpperCase();
        }
    }
    
    public Rule getRule()
    {
        return this.rule;
    }
        
    public void setRule(Rule rule)
    {        
        this.rule = rule;
    }
    
    /**
     * Castor setter to set the rule id.
     * 
     * @param ruleId The rule identifier.
     */
    public void setRuleId(String ruleId)
    {
        this.ruleId = ruleId;
    }
    
    /**
     * Castor accessor to get the rule id.
     * 
     * @return The rule identifier.
     */
    public String getRuleId()
    {
        return this.ruleId;
    }
        
}
