/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.util.Map;
import java.util.Vector;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ResourceBundleHelper;
import org.tp23.antinstaller.antmod.Launcher;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class AntLauncherFilter
implements ExecuteFilter {
    private static final ResourceBundleHelper resHelper = new ResourceBundleHelper("org.tp23.antinstaller.renderer.Res");

    public void exec(InstallerContext ctx) throws InstallException {
        if (ctx.getInstaller().isVerbose()) {
            ctx.log("Starting Ant Launcher");
        }
        try {
            Vector argsList = ctx.getInstaller().getTargets(ctx);
            Object[] argsArr = new String[argsList.size() + 4];
            argsList.toArray(argsArr);
            if (ctx.getInstaller().isVerbose()) {
                ctx.log("Running targets:" + this.printArray(argsArr));
            }
            System.out.println("Targets:" + this.printArray(argsArr));
            argsArr[argsArr.length - 2] = "-lib";
            argsArr[argsArr.length - 1] = "antlib";
            argsArr[argsArr.length - 4] = "-buildfile";
            argsArr[argsArr.length - 3] = ctx.getFileRoot().getAbsolutePath() + System.getProperty("file.separator") + ctx.getAntBuildFile();
            System.setOut(ctx.getAntOutputRenderer().getOut());
            System.setErr(ctx.getAntOutputRenderer().getErr());
            Map properties = ctx.getInstaller().getResultContainer().getAllProperties();
            Launcher launcher = new Launcher(properties);
            int ok = launcher.run((String[])argsArr, ctx);
            if (ok != 0) {
                throw new InstallException(resHelper.getMessage("ant.failure"));
            }
            ctx.setInstallSucceded(true);
            ctx.log("Ant finished");
            ctx.getRunner().antFinished();
        }
        catch (Throwable ex) {
            throw new InstallException("Error running the install, " + ex.getMessage(), ex);
        }
    }

    private String printArray(Object[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length - 4; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }
}

