/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.awt.GraphicsConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.antmod.FeedbackListener;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.antinstaller.renderer.swing.SwingMessageRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.runtime.AntRunner;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class SwingRunner
extends AntRunner
implements Runner,
PageCompletionListener {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected SwingInstallerContext swingCtx = null;
    private JFrame frame = new JFrame();
    private List pageRenderers;
    private volatile boolean doAnt = false;
    protected Thread initialThread;
    protected IfPropertyHelper ifHelper;
    protected InstallerContext ctx;
    protected Logger logger;
    protected Installer installer;

    public SwingRunner(InstallerContext ctx) {
        super(ctx);
        this.swingCtx = new SwingInstallerContext(ctx, this.frame);
        SwingMessageRenderer smr = new SwingMessageRenderer();
        smr.setOwner(this.frame);
        ctx.setMessageRenderer(smr);
        ctx.setBuildListener(new FeedbackListener(this.swingCtx));
        this.ifHelper = new IfPropertyHelper(ctx);
        this.logger = ctx.getLogger();
        this.installer = ctx.getInstaller();
        this.ctx = ctx;
    }

    public boolean runInstaller() throws InstallException {
        try {
            this.frame.setTitle(this.installer.getName());
            this.frame.setDefaultCloseOperation(3);
            this.frame.setSize(SizeConstants.PAGE_WIDTH, SizeConstants.PAGE_HEIGHT);
            this.frame.getRootPane().setDoubleBuffered(true);
            this.setLocation(this.frame);
            this.setIcon(this.frame, this.installer);
            this.preparePages(this.installer.getPages(), this.ctx);
            this.showFirstPage();
            this.initialThread = Thread.currentThread();
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
            return this.doAnt;
        }
        catch (Exception ex) {
            this.logger.log("Fatal exception: " + ex.getMessage());
            if (this.ctx.getInstaller().isVerbose()) {
                this.logger.log(ex);
            }
            this.ctx.getMessageRenderer().printMessage("Fatal exception: " + ex.getMessage());
            throw new InstallException("", ex);
        }
    }

    public void pageBack(Page page) {
        if (page.isAbort()) {
            this.abort();
            return;
        }
        Page[] pages = this.installer.getPages();
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] != page || i <= 0) continue;
            int nextIdx = i - 1;
            try {
                while (!this.ifHelper.ifTarget(pages[nextIdx], pages) || !this.ifHelper.ifProperty(pages[nextIdx])) {
                    --nextIdx;
                }
            }
            catch (InstallException instExc) {
                this.logger.log("InstallException rendering page:" + page.getName());
                this.logger.log(this.installer, instExc);
            }
            SwingPageRenderer renderer = (SwingPageRenderer)this.pageRenderers.get(nextIdx);
            this.ctx.setCurrentPage(pages[nextIdx]);
            try {
                this.renderNext(renderer);
            }
            catch (InstallException ex) {
                this.logger.log("InstallExcepiton rendering page:" + page.getName());
                this.logger.log(this.installer, ex);
            }
            catch (ClassNotFoundException ex) {
                this.logger.log("ClassNotFoundException rendering page:" + page.getName());
                this.logger.log(this.installer, ex);
            }
            return;
        }
    }

    public void pageComplete(Page page) {
        block12: {
            try {
                if (page.isAbort()) {
                    this.abort();
                    return;
                }
                this.runPost(page);
                Page[] pages = this.installer.getPages();
                for (int i = 0; i < pages.length; ++i) {
                    if (pages[i] != page) continue;
                    SwingPageRenderer currentRenderer = (SwingPageRenderer)this.pageRenderers.get(i);
                    boolean validationPassed = false;
                    try {
                        currentRenderer.updateInputFields();
                        validationPassed = currentRenderer.validateFields();
                    }
                    catch (ValidationException ve) {
                        this.logger.log("ValidationException rendering page:" + page.getName());
                        this.logger.log(this.installer, ve);
                        return;
                    }
                    if (!validationPassed) {
                        return;
                    }
                    if (i < pages.length - 1) {
                        int nextIdx = i + 1;
                        while (!this.ifHelper.ifTarget(pages[nextIdx], pages) || !this.ifHelper.ifProperty(pages[nextIdx])) {
                            ++nextIdx;
                        }
                        SwingPageRenderer renderer = (SwingPageRenderer)this.pageRenderers.get(nextIdx);
                        this.ctx.setCurrentPage(pages[nextIdx]);
                        try {
                            this.renderNext(renderer);
                        }
                        catch (InstallException ex) {
                            this.logger.log("InstallException rendering page:" + page.getName());
                            this.logger.log(this.installer, ex);
                        }
                        catch (ClassNotFoundException ex) {
                            this.logger.log("ClassNotFoundException rendering page:" + page.getName());
                            this.logger.log(this.installer, ex);
                        }
                        return;
                    }
                    if (i != pages.length - 1) continue;
                    currentRenderer.getBackButton().setEnabled(false);
                    currentRenderer.getNextButton().setEnabled(false);
                    currentRenderer.getFinishButton().setEnabled(false);
                    this.doAnt = true;
                    this.initialThread.interrupt();
                    return;
                }
            }
            catch (Throwable e) {
                this.ctx.log("Throwable during page completion:" + e.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block12;
                this.ctx.log(e);
            }
        }
    }

    protected void showFirstPage() throws Exception {
        this.ctx.setCurrentPage(this.installer.getPages()[0]);
        this.renderNext((SwingPageRenderer)this.pageRenderers.get(0));
    }

    private void preparePages(Page[] pages, InstallerContext ctx) throws Exception {
        this.pageRenderers = new ArrayList();
        for (int i = 0; i < pages.length; ++i) {
            SwingPageRenderer renderer = RendererFactory.getSwingPageRenderer(pages[i]);
            if (i == 0) {
                renderer.getBackButton().setEnabled(false);
            }
            renderer.setContext(this.swingCtx);
            renderer.setPageCompletionListener(this);
            renderer.setPage(pages[i]);
            renderer.instanceInit();
            this.pageRenderers.add(renderer);
            if (!(renderer instanceof AntOutputRenderer)) continue;
            ctx.setAntOutputRenderer((AntOutputRenderer)((Object)renderer));
        }
    }

    protected void renderNext(SwingPageRenderer renderer) throws ClassNotFoundException, InstallException {
        renderer.updateDefaultValues();
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(renderer);
        this.frame.getContentPane().repaint();
        this.frame.show();
        if (renderer.getNextButton().isEnabled()) {
            renderer.getNextButton().requestFocus();
        } else if (renderer.getFinishButton().isEnabled()) {
            renderer.getFinishButton().requestFocus();
        }
    }

    private void setLocation(JFrame frame) {
        GraphicsConfiguration config = frame.getGraphicsConfiguration();
        int x = (int)config.getBounds().getCenterX() - SizeConstants.PAGE_WIDTH / 2;
        int y = (int)config.getBounds().getCenterY() - SizeConstants.PAGE_HEIGHT / 2;
        frame.setLocation(x, y);
        frame.setResizable(false);
    }

    private void setIcon(JFrame frame, Installer installer) {
        String iconResource = installer.getWindowIcon();
        try {
            if (iconResource == null) {
                return;
            }
            InputStream in = this.getClass().getResourceAsStream(iconResource);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            int read = 0;
            read = in.read(buffer);
            while (read != -1) {
                baos.write(buffer, 0, read);
                read = in.read(buffer);
            }
            ImageIcon icon = new ImageIcon(baos.toByteArray());
            frame.setIconImage(icon.getImage());
        }
        catch (Exception ex) {
            this.logger.log("Can not load icon resource: " + iconResource);
            this.logger.log(installer, ex);
        }
    }

    public void antFinished() {
        SwingPageRenderer renderer = (SwingPageRenderer)this.pageRenderers.get(this.pageRenderers.size() - 1);
        renderer.getBackButton().setEnabled(false);
        renderer.getNextButton().setEnabled(false);
        renderer.getCancelButton().setEnabled(false);
        renderer.getFinishButton().setText(res.getString("exit"));
        renderer.getFinishButton().setEnabled(true);
        renderer.getFinishButton().requestFocus();
        renderer.getTitleLabel().setText(res.getString("complete"));
        this.ctx.getAntOutputRenderer().getErr().flush();
        this.ctx.getAntOutputRenderer().getOut().flush();
        this.ctx.getMessageRenderer().printMessage(res.getString("finished"));
    }

    public void fatalError() {
        List renderers = this.getPageRenderers();
        if (renderers != null && renderers.size() > 0) {
            SwingPageRenderer renderer = (SwingPageRenderer)renderers.get(renderers.size() - 1);
            renderer.getBackButton().setEnabled(false);
            renderer.getNextButton().setEnabled(false);
            renderer.getCancelButton().setEnabled(false);
            renderer.getFinishButton().setText(res.getString("exit"));
            renderer.getFinishButton().setEnabled(true);
            renderer.getFinishButton().requestFocus();
            renderer.getTitleLabel().setText(res.getString("failed"));
        }
    }

    public String toString() {
        return "SwingRunner";
    }

    private void abort() {
        this.doAnt = false;
        this.initialThread.interrupt();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public List getPageRenderers() {
        return this.pageRenderers;
    }
}

