/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.anttasks;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.jetspeed.anttasks.StartDerby;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.SQLExec;

public class ExecuteSQL
extends SQLExec {
    @Override
    public void execute() throws BuildException {
        try {
            System.out.println("Executing SQL statement");
            super.execute();
        }
        catch (Exception e) {
            throw new BuildException(e, this.getLocation());
        }
        finally {
            if (StartDerby.getConnection(this.getProject()) != null) {
                try {
                    if (!StartDerby.getConnection(this.getProject()).isClosed()) {
                        StartDerby.getConnection(this.getProject()).close();
                    }
                }
                catch (Exception exception) {}
                StartDerby.setConnection(this.getProject(), null);
            }
        }
    }

    @Override
    protected Connection getConnection() throws BuildException {
        if (StartDerby.getDriver(this.getProject()) == null) {
            throw new BuildException("Derby driver not established!", this.getLocation());
        }
        if (StartDerby.getConnection(this.getProject()) != null) {
            System.out.println("Connection already established");
            return StartDerby.getConnection(this.getProject());
        }
        if (this.getUrl() == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        try {
            Connection conn;
            this.log("connecting to " + this.getUrl(), 3);
            Properties info = new Properties();
            if (this.getUserId() != null) {
                info.put("user", this.getUserId());
            }
            if (this.getPassword() != null) {
                info.put("password", this.getPassword());
            }
            if ((conn = StartDerby.getDriver(this.getProject()).connect(this.getUrl(), info)) == null) {
                throw new SQLException("No suitable Driver for " + this.getUrl());
            }
            conn.setAutoCommit(this.isAutocommit());
            System.out.println("Connection to " + this.getUrl() + " established");
            StartDerby.setConnection(this.getProject(), conn);
            return conn;
        }
        catch (SQLException e) {
            throw new BuildException(e, this.getLocation());
        }
    }
}

